/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.mule.runtime.api.artifact.ArtifactCoordinates;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.extension.api.loader.ExtensionModelLoadingRequest;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaExtensionModelLoader;
import org.mule.runtime.module.extension.mule.internal.loader.MuleSdkPluginExtensionModelLoader;
import org.mule.runtime.module.extension.mule.internal.operation.FakeExpressionLanguageMetadataService;

public final class ExtensionModelTestUtils {
    private static final ExpressionLanguageMetadataService expressionLanguageMetadataService = new FakeExpressionLanguageMetadataService();
    public static final ArtifactCoordinates TEST_ARTIFACT_COORDINATES = new BundleDescriptor.Builder().setArtifactId("TestExtension").setGroupId("TestGroup").setVersion("1.2.3").build();

    private ExtensionModelTestUtils() {
    }

    public static OperationModel getOperationModel(ExtensionModel extensionModel, String operationName) {
        return (OperationModel)extensionModel.getOperationModel(operationName).orElseThrow(() -> new IllegalArgumentException(String.format("Operation '%s' not found in extension model '%s'", operationName, extensionModel.getName())));
    }

    public static Set<String> getRaisedErrors(ExtensionModel extensionModel) {
        return extensionModel.getErrorModels().stream().map(Object::toString).collect(Collectors.toSet());
    }

    public static Set<String> getRaisedErrors(OperationModel operationModel) {
        return operationModel.getErrorModels().stream().map(Object::toString).collect(Collectors.toSet());
    }

    public static void assertRaisedErrors(ExtensionModel extensionModel, String operationName, Collection<String> expectedSetOfErrors) {
        OperationModel operationModel = ExtensionModelTestUtils.getOperationModel(extensionModel, operationName);
        Set<String> actualRaisedErrors = ExtensionModelTestUtils.getRaisedErrors(operationModel);
        Assert.assertThat((String)String.format("Actual set for '%s': %s", operationName, actualRaisedErrors), actualRaisedErrors, (Matcher)Matchers.hasSize((int)expectedSetOfErrors.size()));
        for (String item : expectedSetOfErrors) {
            Assert.assertThat((String)String.format("Actual set for '%s': %s", operationName, actualRaisedErrors), actualRaisedErrors, (Matcher)Matchers.hasItem((Object)item));
        }
    }

    public static <T> Set<T> asSet(T ... a) {
        return Arrays.stream(a).collect(Collectors.toSet());
    }

    public static ExtensionModel loadMuleSdkExtension(String extensionFile, ClassLoader classLoader, Set<ExtensionModel> dependencies) {
        ExtensionModelLoadingRequest loadingRequest = ExtensionModelLoadingRequest.builder((ClassLoader)classLoader, (DslResolvingContext)DslResolvingContext.getDefault(dependencies)).addParameter("version", (Object)TEST_ARTIFACT_COORDINATES.getVersion()).addParameter("muleSDK.resource", (Object)extensionFile).addParameter("muleSDK.expressionLanguageMetadataService", (Object)expressionLanguageMetadataService).setArtifactCoordinates(TEST_ARTIFACT_COORDINATES).setResolveMinMuleVersion(true).build();
        return new MuleSdkPluginExtensionModelLoader().loadExtensionModel(loadingRequest);
    }

    public static ExtensionModel loadMuleSdkExtension(String extensionFile, Set<ExtensionModel> dependencies) {
        return ExtensionModelTestUtils.loadMuleSdkExtension(extensionFile, Thread.currentThread().getContextClassLoader(), dependencies);
    }

    public static ExtensionModel loadJavaSdkExtension(Class<?> extensionClass, ClassLoader classLoader, Set<ExtensionModel> dependencies) {
        ExtensionModelLoadingRequest loadingRequest = ExtensionModelLoadingRequest.builder((ClassLoader)classLoader, (DslResolvingContext)DslResolvingContext.getDefault(dependencies)).addParameter("type", (Object)extensionClass.getName()).addParameter("version", (Object)"1.0.0-SNAPSHOT").build();
        return new DefaultJavaExtensionModelLoader().loadExtensionModel(loadingRequest);
    }

    public static ExtensionModel loadJavaSdkExtension(Class<?> extensionClass, Set<ExtensionModel> dependencies) {
        return ExtensionModelTestUtils.loadJavaSdkExtension(extensionClass, Thread.currentThread().getContextClassLoader(), dependencies);
    }
}

