/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.module.extension.mule.internal.loader.AbstractMuleSdkExtensionModelTestCase;

@Feature(value="Reuse")
@Story(value="Application Extension Model")
public class ParameterLayoutExtensionModelTestCase
extends AbstractMuleSdkExtensionModelTestCase {
    protected String getConfigFile() {
        return "mule-parameter-layout-metadata-config.xml";
    }

    @Test
    public void fullConfiguredParameterLayout() {
        ExtensionModel extensionModel = this.getAppExtensionModel();
        OperationModel operationModel = this.getOperationModel(extensionModel, "fullParameterLayoutOperation");
        ParameterModel parameterModel = this.getParameterModel(operationModel, "theParameter");
        DisplayModel displayModel = (DisplayModel)parameterModel.getDisplayModel().get();
        Assert.assertThat((Object)displayModel.getDisplayName(), (Matcher)Matchers.is((Object)"The display name"));
        Assert.assertThat((Object)displayModel.getSummary(), (Matcher)Matchers.is((Object)"The summary"));
        Assert.assertThat((Object)displayModel.getExample(), (Matcher)Matchers.is((Object)"The example"));
        PathModel pathModel = (PathModel)displayModel.getPathModel().get();
        Assert.assertThat((Object)pathModel.getType(), (Matcher)Matchers.is((Object)PathModel.Type.FILE));
        Assert.assertThat((Object)pathModel.acceptsUrls(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)pathModel.getLocation(), (Matcher)Matchers.is((Object)PathModel.Location.EMBEDDED));
        Assert.assertThat((Object)pathModel.getFileExtensions(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"txt", "xml", "png"}));
        LayoutModel layoutModel = (LayoutModel)parameterModel.getLayoutModel().get();
        Assert.assertThat((Object)((Integer)layoutModel.getOrder().get()), (Matcher)Matchers.is((Object)4));
        Assert.assertThat((Object)layoutModel.isText(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)layoutModel.isPassword(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)parameterModel.getSemanticTerms().contains("connectivity.clientSecret"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)displayModel.getClassValueModel().isPresent(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)layoutModel.getTabName().isPresent(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)layoutModel.isQuery(), (Matcher)Matchers.is((Object)false));
    }
}

