/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.operation;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Story;
import java.util.Optional;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.module.extension.mule.internal.operation.MuleOperationExecutionTestCase;
import org.mule.test.marvel.ironman.IronMan;

@Features(value={@Feature(value="Reuse"), @Feature(value="Lazy Initialization")})
@Story(value="Operations")
public class LazyInitMuleOperationExecutionTestCase
extends MuleOperationExecutionTestCase {
    @Inject
    private LazyComponentInitializer lazyComponentInitializer;

    public boolean enableLazyInit() {
        return true;
    }

    @Override
    @Test
    @Description(value="Calls a flow that executes the <this:salute-aggressively> operation which is configurable")
    public void executeConfigurableOperation() throws Exception {
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"ironMan").build()), (Matcher)CoreMatchers.is(Optional.empty()));
        CoreEvent resultEvent = this.flowRunner("configurableOperationFlow").run();
        String result = (String)resultEvent.getMessage().getPayload().getValue();
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)"KABOOM!"));
        ConfigurationInstance config = muleContext.getExtensionManager().getConfiguration("ironMan", this.testEvent());
        Assert.assertThat((Object)config, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        IronMan ironManConfig = (IronMan)config.getValue();
        Assert.assertThat((Object)ironManConfig.getMissilesFired(), (Matcher)CoreMatchers.is((Object)1));
    }

    protected FlowRunner flowRunner(String flowName) {
        this.lazyComponentInitializer.initializeComponent(Location.builderFromStringRepresentation((String)flowName).build());
        return super.flowRunner(flowName);
    }
}

