/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.validation;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.module.extension.mule.internal.validation.AbstractConfigFileValidationTestCase;

@Feature(value="Reuse")
@Story(value="Operations")
public class InvalidExclusiveOptionalsOperationInvocationTestCase
extends AbstractConfigFileValidationTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    @Description(value="Tries to load a configuration file which calls an operation with conflicting exclusive parameters and verifies the error message")
    public void conflictingExclusiveParameters() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("[validation/salutation-exclusive-parameters-operation.xml:11]: Element <helloPlace>, the following parameters cannot be set at the same time: [city, country].");
        this.parseConfig("validation/salutation-exclusive-parameters-operation.xml");
    }

    @Test
    @Description(value="Tries to load a configuration file which calls an operation with missing required exclusive parameters and verifies the error message")
    public void missingRequiredExclusiveParameters() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("[validation/salutation-exclusive-parameters-required-operation.xml:11]: Element <General> requires that one of its optional parameters must be set, but all of them are missing. One of the following must be set: [city, country].");
        this.parseConfig("validation/salutation-exclusive-parameters-required-operation.xml");
    }
}

