/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.type.TypeCatalog;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.config.MuleManifest;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.module.extension.internal.capability.xml.schema.SchemaGenerator;
import org.mule.runtime.module.extension.internal.loader.enricher.JavaXmlDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaExtensionModelLoader;
import org.mule.runtime.module.extension.internal.runtime.connectivity.basic.GlobalInnerPojoConnector;
import org.mule.runtime.module.extension.internal.runtime.connectivity.basic.GlobalPojoConnector;
import org.mule.runtime.module.extension.internal.runtime.connectivity.basic.ListConnector;
import org.mule.runtime.module.extension.internal.runtime.connectivity.basic.MapConnector;
import org.mule.runtime.module.extension.internal.runtime.connectivity.basic.StringListConnector;
import org.mule.runtime.module.extension.internal.runtime.connectivity.basic.TestConnector;
import org.mule.runtime.module.extension.soap.internal.loader.SoapExtensionModelLoader;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.marvel.MarvelExtension;
import org.mule.test.metadata.extension.MetadataExtension;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.test.oauth.TestOAuthExtension;
import org.mule.test.petstore.extension.PetStoreConnector;
import org.mule.test.ram.RickAndMortyExtension;
import org.mule.test.soap.extension.FootballSoapExtension;
import org.mule.test.subtypes.extension.SubTypesMappingConnector;
import org.mule.test.transactional.TransactionalExtension;
import org.mule.test.typed.value.extension.extension.TypedValueExtension;
import org.mule.test.vegan.extension.VeganExtension;

@SmallTest
@RunWith(value=Parameterized.class)
public class SchemaGeneratorTestCase
extends AbstractMuleTestCase {
    static final Map<String, ExtensionModel> extensionModels = new HashMap<String, ExtensionModel>();
    private static ExtensionModelLoader javaLoader = new DefaultJavaExtensionModelLoader();
    private static ExtensionModelLoader soapLoader = new SoapExtensionModelLoader();
    @Parameterized.Parameter(value=0)
    public ExtensionModel extensionUnderTest;
    @Parameterized.Parameter(value=1)
    public String expectedXSD;
    private SchemaGenerator generator;
    private String expectedSchema;

    @Parameterized.Parameters(name="{1}")
    public static Collection<Object[]> data() {
        ClassLoader classLoader = SchemaGeneratorTestCase.class.getClassLoader();
        ServiceRegistry serviceRegistry = (ServiceRegistry)Mockito.mock(ServiceRegistry.class);
        Mockito.when((Object)serviceRegistry.lookupProviders(DeclarationEnricher.class, classLoader)).thenReturn(Arrays.asList(new JavaXmlDeclarationEnricher()));
        List<SchemaGeneratorTestUnit> extensions = Arrays.asList(new SchemaGeneratorTestUnit(javaLoader, MapConnector.class, "map.xsd"), new SchemaGeneratorTestUnit(javaLoader, ListConnector.class, "list.xsd"), new SchemaGeneratorTestUnit(javaLoader, TestConnector.class, "basic.xsd"), new SchemaGeneratorTestUnit(javaLoader, StringListConnector.class, "string-list.xsd"), new SchemaGeneratorTestUnit(javaLoader, GlobalPojoConnector.class, "global-pojo.xsd"), new SchemaGeneratorTestUnit(javaLoader, GlobalInnerPojoConnector.class, "global-inner-pojo.xsd"), new SchemaGeneratorTestUnit(javaLoader, VeganExtension.class, "vegan.xsd"), new SchemaGeneratorTestUnit(javaLoader, PetStoreConnector.class, "petstore.xsd"), new SchemaGeneratorTestUnit(javaLoader, MetadataExtension.class, "metadata.xsd"), new SchemaGeneratorTestUnit(javaLoader, HeisenbergExtension.class, "heisenberg.xsd"), new SchemaGeneratorTestUnit(javaLoader, TransactionalExtension.class, "tx-ext.xsd"), new SchemaGeneratorTestUnit(javaLoader, SubTypesMappingConnector.class, "subtypes.xsd"), new SchemaGeneratorTestUnit(javaLoader, MarvelExtension.class, "marvel.xsd"), new SchemaGeneratorTestUnit(soapLoader, FootballSoapExtension.class, "soap.xsd"), new SchemaGeneratorTestUnit(soapLoader, RickAndMortyExtension.class, "ram.xsd"), new SchemaGeneratorTestUnit(javaLoader, TypedValueExtension.class, "typed-value.xsd"), new SchemaGeneratorTestUnit(javaLoader, TestOAuthExtension.class, "test-oauth.xsd"));
        BiFunction<Class, ExtensionModelLoader, ExtensionModel> createExtensionModel = (extension, loader) -> {
            ExtensionModel model = SchemaGeneratorTestCase.loadExtension(extension, loader);
            if (extensionModels.put(model.getName(), model) != null) {
                throw new IllegalArgumentException(String.format("Extension names must be unique. Name [%s] for extension [%s] was already used", model.getName(), extension.getName()));
            }
            return model;
        };
        return extensions.stream().map(e -> new Object[]{createExtensionModel.apply(e.getExtensionClass(), e.getLoader()), e.getFileName()}).collect(Collectors.toList());
    }

    @Before
    public void setup() throws IOException {
        this.generator = new SchemaGenerator();
        this.expectedSchema = IOUtils.getResourceAsString((String)("schemas/" + this.expectedXSD), ((Object)((Object)this)).getClass());
    }

    @Test
    public void generate() throws Exception {
        XmlDslModel languageModel = this.extensionUnderTest.getXmlDslModel();
        String schema = this.generator.generate(this.extensionUnderTest, languageModel, (DslResolvingContext)new SchemaTestDslContext());
        ExtensionsTestUtils.compareXML((String)this.expectedSchema, (String)schema);
    }

    public static ExtensionModel loadExtension(Class<?> clazz, ExtensionModelLoader loader) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", clazz.getName());
        params.put("version", MuleManifest.getProductVersion());
        DslResolvingContext dslResolvingContext = DslResolvingContext.getDefault(Collections.emptySet());
        return loader.loadExtensionModel(clazz.getClassLoader(), dslResolvingContext, params);
    }

    static class SchemaGeneratorTestUnit {
        final ExtensionModelLoader loader;
        final Class<?> extensionClass;
        final String fileName;

        SchemaGeneratorTestUnit(ExtensionModelLoader loader, Class<?> extensionClass, String fileName) {
            this.loader = loader;
            this.extensionClass = extensionClass;
            this.fileName = fileName;
        }

        ExtensionModelLoader getLoader() {
            return this.loader;
        }

        Class<?> getExtensionClass() {
            return this.extensionClass;
        }

        String getFileName() {
            return this.fileName;
        }
    }

    private static class SchemaTestDslContext
    implements DslResolvingContext {
        private SchemaTestDslContext() {
        }

        public Optional<ExtensionModel> getExtension(String name) {
            return Optional.ofNullable(extensionModels.get(name));
        }

        public Set<ExtensionModel> getExtensions() {
            return ImmutableSet.copyOf(extensionModels.values());
        }

        public TypeCatalog getTypeCatalog() {
            return TypeCatalog.getDefault((Set)ImmutableSet.copyOf(extensionModels.values()));
        }
    }
}

