/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.description;

import com.google.common.truth.SubjectFactory;
import com.google.common.truth.Truth;
import com.google.testing.compile.JavaSourcesSubject;
import com.google.testing.compile.JavaSourcesSubjectFactory;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNull;
import org.junit.Test;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.DescribedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.resources.GeneratedResource;
import org.mule.runtime.extension.internal.loader.DefaultExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.ExtensionModelFactory;
import org.mule.runtime.module.extension.internal.AbstractAnnotationProcessorTestCase;
import org.mule.runtime.module.extension.internal.capability.xml.TestExtensionWithDocumentation;
import org.mule.runtime.module.extension.internal.capability.xml.description.ExtensionDescriptionDocumenter;
import org.mule.runtime.module.extension.internal.loader.enricher.ExtensionDescriptionsEnricher;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.resources.documentation.ExtensionDocumentationResourceGenerator;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
public class ExtensionDescriptionDocumenterTestCase
extends AbstractAnnotationProcessorTestCase {
    @Test
    public void persistDocumentation() throws Exception {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/META-INF/documentation-extension-descriptions.xml");
        MatcherAssert.assertThat((Object)in, (Matcher)Matchers.is((Matcher)IsNull.notNullValue()));
        String expectedXml = IOUtils.toString((InputStream)in);
        TestProcessor processor = new TestProcessor();
        this.doCompile(processor);
        ExtensionDocumentationResourceGenerator generator = new ExtensionDocumentationResourceGenerator();
        GeneratedResource resource = (GeneratedResource)generator.generateResource(processor.getExtensionModel()).orElseThrow(() -> new RuntimeException("No Documentation Generated"));
        ExtensionsTestUtils.compareXML((String)expectedXml, (String)new String(resource.getContent()));
    }

    @Test
    public void loadDocumentationFromFile() throws Exception {
        DefaultExtensionLoadingContext ctx = new DefaultExtensionLoadingContext(Thread.currentThread().getContextClassLoader(), DslResolvingContext.getDefault(Collections.emptySet()));
        DefaultJavaModelLoaderDelegate loader = new DefaultJavaModelLoaderDelegate(TestExtensionWithDocumentation.class, "1.0.0-dev");
        loader.declare((ExtensionLoadingContext)ctx);
        ExtensionDescriptionsEnricher enricher = new ExtensionDescriptionsEnricher();
        enricher.enrich((ExtensionLoadingContext)ctx);
        ExtensionModelFactory factory = new ExtensionModelFactory();
        ExtensionModel extensionModel = factory.create((ExtensionLoadingContext)ctx);
        this.assertDescriptions(extensionModel);
    }

    @Test
    public void describeDescriptions() throws Exception {
        TestProcessor processor = new TestProcessor();
        this.doCompile(processor);
        this.assertDescriptions(processor.getExtensionModel());
    }

    private void assertDescriptions(ExtensionModel declaration) {
        this.assertDescription((DescribedObject)declaration, "Test Extension Description");
        List configurations = declaration.getConfigurationModels();
        MatcherAssert.assertThat((Object)configurations, (Matcher)Matchers.hasSize((int)2));
        ConfigurationModel first = (ConfigurationModel)configurations.get(1);
        this.assertDescription((DescribedObject)first, "This is some Config documentation.");
        this.assertDescription((DescribedObject)first.getConnectionProviders().get(0), "Another Provider Documentation");
        this.assertDescription((DescribedObject)first.getConnectionProviders().get(1), "Provider Documentation");
        ConfigurationModel second = (ConfigurationModel)configurations.get(0);
        this.assertDescription((DescribedObject)second, "This is some Another Config documentation.");
        this.assertDescription((DescribedObject)second.getConnectionProviders().get(0), "Another Provider Documentation");
        List params = first.getAllParameterModels();
        this.assertDescription((DescribedObject)params.get(0), "Config parameter");
        this.assertDescription((DescribedObject)params.get(1), "Config Parameter with an Optional value");
        this.assertDescription((DescribedObject)params.get(2), "Group parameter 1");
        this.assertDescription((DescribedObject)params.get(3), "Group parameter 2");
        List operations = declaration.getOperationModels();
        OperationModel operation = this.getOperationByName(operations, "operation");
        this.assertDescription((DescribedObject)operation, "Test Operation");
        this.assertDescription((DescribedObject)operation.getAllParameterModels().get(0), "test value");
        OperationModel inheritedOperation = this.getOperationByName(operations, "inheritedOperation");
        this.assertDescription((DescribedObject)inheritedOperation, "Inherited Operation Documentation");
        this.assertDescription((DescribedObject)inheritedOperation.getAllParameterModels().get(0), "parameter documentation for an inherited operation.");
        OperationModel greetFriend = this.getOperationByName(operations, "greetFriend");
        this.assertDescription((DescribedObject)greetFriend, "This method greets a friend");
        this.assertDescription((DescribedObject)greetFriend.getAllParameterModels().get(0), "This is one of my friends");
        this.assertDescription((DescribedObject)greetFriend.getAllParameterModels().get(1), "Some other friend");
        List connectedOperations = first.getOperationModels();
        OperationModel connectedOpe = (OperationModel)connectedOperations.get(0);
        this.assertDescription((DescribedObject)connectedOpe, "Test Operation with blank parameter description");
        this.assertDescription((DescribedObject)connectedOpe.getAllParameterModels().get(0), "");
    }

    private void doCompile(TestProcessor processor) throws Exception {
        ((JavaSourcesSubject)Truth.assert_().about((SubjectFactory)JavaSourcesSubjectFactory.javaSources()).that(this.testSourceFiles())).withCompilerOptions(new String[]{"-Aextension.version=1.0.0-dev"}).processedWith((Processor)processor, new Processor[0]).compilesWithoutError();
    }

    private void assertDescription(DescribedObject object, String desc) {
        MatcherAssert.assertThat((Object)object.getDescription(), (Matcher)Matchers.is((Object)desc));
    }

    private OperationModel getOperationByName(List<OperationModel> ops, String opeName) {
        return ops.stream().filter(operationModel -> operationModel.getName().equals(opeName)).findAny().orElse(null);
    }

    @SupportedAnnotationTypes(value={"org.mule.runtime.extension.api.annotation.Extension"})
    @SupportedSourceVersion(value=SourceVersion.RELEASE_8)
    @SupportedOptions(value={"extension.version"})
    private class TestProcessor
    extends AbstractProcessor {
        private ExtensionDeclaration declaration;
        private DefaultExtensionLoadingContext ctx;

        private TestProcessor() {
        }

        @Override
        public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
            if (this.declaration == null) {
                ExtensionDescriptionDocumenter declarer = new ExtensionDescriptionDocumenter(this.processingEnv, roundEnv);
                Set<? extends Element> extensionElements = roundEnv.getElementsAnnotatedWith(Extension.class);
                MatcherAssert.assertThat(extensionElements, (Matcher)Matchers.hasSize((int)1));
                Element extension = extensionElements.iterator().next();
                MatcherAssert.assertThat((Object)extension, (Matcher)Matchers.instanceOf(TypeElement.class));
                this.ctx = new DefaultExtensionLoadingContext(Thread.currentThread().getContextClassLoader(), DslResolvingContext.getDefault(Collections.emptySet()));
                DefaultJavaModelLoaderDelegate loader = new DefaultJavaModelLoaderDelegate(TestExtensionWithDocumentation.class, "1.0.0-dev");
                this.declaration = (ExtensionDeclaration)loader.declare((ExtensionLoadingContext)this.ctx).getDeclaration();
                declarer.document(this.declaration, (TypeElement)extension);
            }
            return false;
        }

        ExtensionModel getExtensionModel() {
            ExtensionModelFactory factory = new ExtensionModelFactory();
            return factory.create((ExtensionLoadingContext)this.ctx);
        }
    }
}

