/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.schema;

import java.util.Arrays;
import java.util.Collections;
import java.util.ServiceLoader;
import javax.annotation.processing.ProcessingEnvironment;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.SubTypesModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.extension.api.dsl.syntax.resources.spi.DslResourceFactory;
import org.mule.runtime.extension.api.resources.GeneratedResource;
import org.mule.runtime.extension.api.resources.ResourcesGenerator;
import org.mule.runtime.extension.api.resources.spi.GeneratedResourceFactory;
import org.mule.runtime.module.extension.internal.capability.xml.schema.SchemaXmlResourceFactory;
import org.mule.runtime.module.extension.internal.capability.xml.schema.SpringHandlerBundleResourceFactory;
import org.mule.runtime.module.extension.internal.capability.xml.schema.SpringSchemaBundleResourceFactory;
import org.mule.runtime.module.extension.internal.config.ExtensionNamespaceHandler;
import org.mule.runtime.module.extension.internal.resources.AbstractGeneratedResourceFactoryTestCase;
import org.mule.runtime.module.extension.internal.resources.AnnotationProcessorResourceGenerator;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class XmlGeneratedResourcesTestCase
extends AbstractGeneratedResourceFactoryTestCase {
    private static final String EXTENSION_NAME = "extension";
    private static final String EXTENSION_VERSION = "version";
    private static final String SCHEMA_LOCATION = "mulesoft.com/extension";
    private static final String UNESCAPED_LOCATION_PREFIX = "http://";
    private static final String ESCAPED_LOCATION_PREFIX = "http\\://";
    private static final String SCHEMA_NAME = "mule-extension.xsd";
    @Mock
    private ExtensionModel extensionModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ServiceRegistry serviceRegistry;
    @Mock
    private ProcessingEnvironment processingEnvironment;
    private ResourcesGenerator generator;
    private XmlDslModel xmlDslModel;
    private SpringHandlerBundleResourceFactory springHandlerFactory = new SpringHandlerBundleResourceFactory();
    private SpringSchemaBundleResourceFactory springSchemaBundleResourceFactory = new SpringSchemaBundleResourceFactory();
    private SchemaXmlResourceFactory schemaXmlResourceFactory = new SchemaXmlResourceFactory();

    @Before
    public void before() {
        this.xmlDslModel = XmlDslModel.builder().setSchemaVersion(EXTENSION_VERSION).setPrefix(EXTENSION_NAME).setNamespace("http://mulesoft.com/extension").setSchemaLocation(String.format("%s/%s/%s", "http://mulesoft.com/extension", "current", SCHEMA_NAME)).setXsdFileName(SCHEMA_NAME).build();
        Mockito.when((Object)this.extensionModel.getXmlDslModel()).thenReturn((Object)this.xmlDslModel);
        ExtensionsTestUtils.mockSubTypes((ExtensionModel)this.extensionModel, (SubTypesModel[])new SubTypesModel[0]);
        Mockito.when((Object)this.extensionModel.getImportedTypes()).thenReturn(Collections.emptySet());
        this.generator = new AnnotationProcessorResourceGenerator(Arrays.asList(this.springHandlerFactory, this.springSchemaBundleResourceFactory, this.schemaXmlResourceFactory), this.processingEnvironment);
        Mockito.when((Object)this.extensionModel.getName()).thenReturn((Object)EXTENSION_NAME);
        Mockito.when((Object)this.extensionModel.getVersion()).thenReturn((Object)EXTENSION_VERSION);
    }

    protected Class<? extends GeneratedResourceFactory>[] getResourceFactoryTypes() {
        return new Class[]{SpringHandlerBundleResourceFactory.class, SchemaXmlResourceFactory.class, SpringSchemaBundleResourceFactory.class};
    }

    @Test
    public void spiDiscovery() throws Exception {
        ServiceLoader<DslResourceFactory> services = ServiceLoader.load(DslResourceFactory.class);
        Assert.assertThat((Object)Arrays.stream(this.getResourceFactoryTypes()).allMatch(factoryClass -> {
            for (GeneratedResourceFactory factory : services) {
                if (!factoryClass.isAssignableFrom(factory.getClass())) continue;
                return true;
            }
            return false;
        }), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void generateSchema() throws Exception {
        GeneratedResource resource = (GeneratedResource)this.schemaXmlResourceFactory.generateResource(this.extensionModel).get();
        Assert.assertThat((Object)StringUtils.isBlank((String)new String(resource.getContent())), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void springHandlers() throws Exception {
        GeneratedResource resource = (GeneratedResource)this.springHandlerFactory.generateResource(this.extensionModel).get();
        Assert.assertThat((Object)"spring.handlers", (Matcher)CoreMatchers.equalTo((Object)resource.getPath()));
        Assert.assertThat((Object)new String(resource.getContent()), (Matcher)CoreMatchers.equalTo((Object)String.format("%s=%s\n", "http\\://mulesoft.com/extension", ExtensionNamespaceHandler.class.getName())));
    }

    @Test
    public void springSchemas() throws Exception {
        GeneratedResource resource = (GeneratedResource)this.springSchemaBundleResourceFactory.generateResource(this.extensionModel).get();
        Assert.assertThat((Object)resource.getPath(), (Matcher)CoreMatchers.equalTo((Object)"spring.schemas"));
        StringBuilder expected = new StringBuilder();
        expected.append(String.format("%s/%s/%s=META-INF/%s\n", "http\\://mulesoft.com/extension", EXTENSION_VERSION, SCHEMA_NAME, SCHEMA_NAME));
        expected.append(String.format("%s/%s/%s=META-INF/%s\n", "http\\://mulesoft.com/extension", "current", SCHEMA_NAME, SCHEMA_NAME));
        Assert.assertThat((Object)new String(resource.getContent()), (Matcher)CoreMatchers.equalTo((Object)expected.toString()));
    }
}

