/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.resources;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.extension.api.persistence.ExtensionModelJsonSerializer;
import org.mule.runtime.module.extension.internal.loader.enricher.JavaXmlDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaExtensionModelLoader;
import org.mule.runtime.module.extension.internal.runtime.connectivity.basic.GlobalInnerPojoConnector;
import org.mule.runtime.module.extension.internal.runtime.connectivity.basic.GlobalPojoConnector;
import org.mule.runtime.module.extension.internal.runtime.connectivity.basic.ListConnector;
import org.mule.runtime.module.extension.internal.runtime.connectivity.basic.MapConnector;
import org.mule.runtime.module.extension.internal.runtime.connectivity.basic.StringListConnector;
import org.mule.runtime.module.extension.internal.runtime.connectivity.basic.TestConnector;
import org.mule.runtime.module.extension.soap.internal.loader.SoapExtensionModelLoader;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.marvel.MarvelExtension;
import org.mule.test.metadata.extension.MetadataExtension;
import org.mule.test.oauth.TestOAuthExtension;
import org.mule.test.petstore.extension.PetStoreConnector;
import org.mule.test.ram.RickAndMortyExtension;
import org.mule.test.soap.extension.FootballSoapExtension;
import org.mule.test.subtypes.extension.SubTypesMappingConnector;
import org.mule.test.transactional.TransactionalExtension;
import org.mule.test.typed.value.extension.extension.TypedValueExtension;
import org.mule.test.vegan.extension.VeganExtension;
import org.skyscreamer.jsonassert.JSONAssert;

@SmallTest
@RunWith(value=Parameterized.class)
public class ExtensionModelJsonGeneratorTestCase
extends AbstractMuleTestCase {
    static final Map<String, ExtensionModel> extensionModels = new HashMap<String, ExtensionModel>();
    private static ExtensionModelLoader javaLoader = new DefaultJavaExtensionModelLoader();
    private static ExtensionModelLoader soapLoader = new SoapExtensionModelLoader();
    @Parameterized.Parameter(value=0)
    public ExtensionModel extensionUnderTest;
    @Parameterized.Parameter(value=1)
    public String expectedSource;
    private ExtensionModelJsonSerializer generator;
    private String expectedJson;

    @Parameterized.Parameters(name="{1}")
    public static Collection<Object[]> data() {
        ClassLoader classLoader = ExtensionModelJsonGeneratorTestCase.class.getClassLoader();
        ServiceRegistry serviceRegistry = (ServiceRegistry)Mockito.mock(ServiceRegistry.class);
        Mockito.when((Object)serviceRegistry.lookupProviders(DeclarationEnricher.class, classLoader)).thenReturn(Arrays.asList(new JavaXmlDeclarationEnricher()));
        List<ExtensionJsonGeneratorTestUnit> extensions = Arrays.asList(new ExtensionJsonGeneratorTestUnit(javaLoader, MapConnector.class, "map.json"), new ExtensionJsonGeneratorTestUnit(javaLoader, ListConnector.class, "list.json"), new ExtensionJsonGeneratorTestUnit(javaLoader, TestConnector.class, "basic.json"), new ExtensionJsonGeneratorTestUnit(javaLoader, StringListConnector.class, "string-list.json"), new ExtensionJsonGeneratorTestUnit(javaLoader, GlobalPojoConnector.class, "global-pojo.json"), new ExtensionJsonGeneratorTestUnit(javaLoader, GlobalInnerPojoConnector.class, "global-inner-pojo.json"), new ExtensionJsonGeneratorTestUnit(javaLoader, VeganExtension.class, "vegan.json"), new ExtensionJsonGeneratorTestUnit(javaLoader, PetStoreConnector.class, "petstore.json"), new ExtensionJsonGeneratorTestUnit(javaLoader, MetadataExtension.class, "metadata.json"), new ExtensionJsonGeneratorTestUnit(javaLoader, HeisenbergExtension.class, "heisenberg.json"), new ExtensionJsonGeneratorTestUnit(javaLoader, TransactionalExtension.class, "tx-ext.json"), new ExtensionJsonGeneratorTestUnit(javaLoader, SubTypesMappingConnector.class, "subtypes.json"), new ExtensionJsonGeneratorTestUnit(javaLoader, MarvelExtension.class, "marvel.json"), new ExtensionJsonGeneratorTestUnit(soapLoader, FootballSoapExtension.class, "soap.json"), new ExtensionJsonGeneratorTestUnit(soapLoader, RickAndMortyExtension.class, "ram.json"), new ExtensionJsonGeneratorTestUnit(javaLoader, TypedValueExtension.class, "typed-value.json"), new ExtensionJsonGeneratorTestUnit(javaLoader, TestOAuthExtension.class, "test-oauth.json"));
        BiFunction<Class, ExtensionModelLoader, ExtensionModel> createExtensionModel = (extension, loader) -> {
            ExtensionModel model = ExtensionModelJsonGeneratorTestCase.loadExtension(extension, loader);
            if (extensionModels.put(model.getName(), model) != null) {
                throw new IllegalArgumentException(String.format("Extension names must be unique. Name [%s] for extension [%s] was already used", model.getName(), extension.getName()));
            }
            return model;
        };
        return extensions.stream().map(e -> new Object[]{createExtensionModel.apply(e.getExtensionClass(), e.getLoader()), e.getFileName()}).collect(Collectors.toList());
    }

    @Before
    public void setup() throws IOException {
        this.generator = new ExtensionModelJsonSerializer(true);
        this.expectedJson = IOUtils.getResourceAsString((String)("models/" + this.expectedSource), ((Object)((Object)this)).getClass()).trim();
    }

    @Test
    public void generate() throws Exception {
        String json = this.generator.serialize(this.extensionUnderTest).trim();
        if (!json.equals(this.expectedJson)) {
            System.out.println(json);
        }
        JSONAssert.assertEquals((String)this.expectedJson, (String)json, (boolean)true);
    }

    @Test
    public void load() throws Exception {
        ExtensionModel result = this.generator.deserialize(this.expectedJson);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)this.extensionUnderTest));
    }

    public static ExtensionModel loadExtension(Class<?> clazz, ExtensionModelLoader loader) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", clazz.getName());
        params.put("version", "4.0.0-SNAPSHOT");
        DslResolvingContext dslResolvingContext = DslResolvingContext.getDefault(Collections.emptySet());
        return loader.loadExtensionModel(clazz.getClassLoader(), dslResolvingContext, params);
    }

    static class ExtensionJsonGeneratorTestUnit {
        final ExtensionModelLoader loader;
        final Class<?> extensionClass;
        final String fileName;

        ExtensionJsonGeneratorTestUnit(ExtensionModelLoader loader, Class<?> extensionClass, String fileName) {
            this.loader = loader;
            this.extensionClass = extensionClass;
            this.fileName = fileName;
        }

        ExtensionModelLoader getLoader() {
            return this.loader;
        }

        Class<?> getExtensionClass() {
            return this.extensionClass;
        }

        String getFileName() {
            return this.fileName;
        }
    }
}

