/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.connector;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class PetStoreRetryPolicyProviderConnectionTestCase
extends AbstractExtensionFunctionalTestCase {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    protected String getConfigFile() {
        return "petstore-retry-policy.xml";
    }

    protected boolean isDisposeContextPerClass() {
        return true;
    }

    @Test
    public void retryPolicyExhaustedDueToInvalidConnectionExecutingOperation() throws Exception {
        this.exception.expect(MessagingException.class);
        this.exception.expectCause(Matchers.is((Matcher)Matchers.instanceOf(ConnectionException.class)));
        this.runFlow("fail-operation-with-connection-exception");
    }

    @Test
    public void retryPolicyExhaustedDueToInvalidConnectionAtValidateTime() throws Exception {
        this.exception.expect(MessagingException.class);
        this.exception.expectCause(Matchers.is((Matcher)Matchers.instanceOf(ConnectionException.class)));
        this.runFlow("fail-connection-validation");
    }

    @Test
    public void retryPolicyNotExecutedDueToNotConnectionExceptionWithException() throws Exception {
        this.exception.expect(MessagingException.class);
        this.exception.expectCause(Matchers.is((Matcher)Matchers.instanceOf(Throwable.class)));
        this.runFlow("fail-operation-with-not-handled-exception");
    }

    @Test
    public void retryPolicyNotExecutedDueToNotConnectionExceptionWithThrowable() throws Throwable {
        this.exception.expect(MessagingException.class);
        this.exception.expectCause(Matchers.is((Matcher)Matchers.instanceOf(Throwable.class)));
        this.runFlow("fail-operation-with-not-handled-throwable");
    }
}

