/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.connector;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.retry.RetryPolicyExhaustedException;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.petstore.extension.FailingPetStoreSource;
import org.mule.test.petstore.extension.PetStoreConnector;

public class PetStoreSourceRetryPolicyProviderTestCase
extends AbstractExtensionFunctionalTestCase {
    public static final int TIMEOUT_MILLIS = 1000;
    public static final int POLL_DELAY_MILLIS = 50;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    protected String getConfigFile() {
        return "petstore-source-retry-policy.xml";
    }

    @Before
    public void setUp() throws Exception {
        PetStoreConnector.timesStarted = 0;
    }

    @After
    public void tearDown() {
        PetStoreConnector.timesStarted = 0;
        if (FailingPetStoreSource.executor != null) {
            FailingPetStoreSource.executor.shutdownNow();
        }
    }

    @Test
    public void retryPolicySourceFailOnStart() throws Exception {
        this.exception.expect(RetryPolicyExhaustedException.class);
        this.exception.expectCause(CoreMatchers.sameInstance((Object)FailingPetStoreSource.connectionException));
        try {
            this.startFlow("source-fail-on-start");
        }
        catch (Exception e) {
            new PollingProber(1000L, 50L).check((Probe)new JUnitLambdaProbe(() -> {
                Assert.assertThat((Object)PetStoreConnector.timesStarted, (Matcher)Matchers.is((Object)2));
                return true;
            }));
            throw e;
        }
    }

    @Test
    public void retryPolicySourceFailOnException() throws Exception {
        this.startFlow("source-fail-on-exception");
        new PollingProber(1000L, 50L).check((Probe)new JUnitLambdaProbe(() -> {
            Assert.assertThat((Object)PetStoreConnector.timesStarted, (Matcher)Matchers.is((Object)3));
            return true;
        }));
    }

    private void startFlow(String flowName) throws Exception {
        ((Flow)this.getFlowConstruct(flowName)).start();
    }
}

