/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.connector;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tls.TlsContextKeyStoreConfiguration;
import org.mule.runtime.api.tls.TlsContextTrustStoreConfiguration;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.test.petstore.extension.PetStoreConnector;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class PetStoreTlsConfigTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final String PASSWORD = "changeit";
    private String name;
    private String configName;
    @Rule
    public SystemProperty systemProperty;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"global tls", "globalTls"}, {"inline tls", "inlineTls"});
    }

    public PetStoreTlsConfigTestCase(String name, String configName) {
        this.name = name;
        this.configName = configName;
        this.systemProperty = new SystemProperty("config", configName);
    }

    protected String getConfigFile() {
        return "petstore-tls-config.xml";
    }

    @Test
    public void tls() throws Exception {
        PetStoreConnector connector = (PetStoreConnector)ExtensionsTestUtils.getConfigurationFromRegistry((String)this.configName, (Event)this.testEvent(), (MuleContext)muleContext);
        TlsContextFactory tls = connector.getTlsContext();
        this.assertTls(tls);
        TlsContextFactory tlsInsidePojo = connector.getCage().getTls();
        this.assertTls(tlsInsidePojo);
    }

    private void assertTls(TlsContextFactory tls) {
        Assert.assertThat((Object)tls, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        TlsContextTrustStoreConfiguration trustStoreConfig = tls.getTrustStoreConfiguration();
        Assert.assertThat((Object)trustStoreConfig.getPath().endsWith("ssltest-cacerts.jks"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)trustStoreConfig.getPassword(), (Matcher)CoreMatchers.equalTo((Object)PASSWORD));
        TlsContextKeyStoreConfiguration keyStoreConfiguration = tls.getKeyStoreConfiguration();
        Assert.assertThat((Object)keyStoreConfiguration.getPath().endsWith("ssltest-keystore.jks"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)keyStoreConfiguration.getKeyPassword(), (Matcher)CoreMatchers.equalTo((Object)PASSWORD));
        Assert.assertThat((Object)keyStoreConfiguration.getPassword(), (Matcher)CoreMatchers.equalTo((Object)PASSWORD));
    }
}

