/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.metadata;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runners.Parameterized;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.Typed;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataComponent;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.internal.metadata.MuleMetadataService;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.metadata.NullMetadataKey;
import org.mule.runtime.module.extension.internal.metadata.MultilevelMetadataKeyBuilder;
import org.mule.test.metadata.extension.resolver.TestMetadataResolverUtils;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public abstract class MetadataExtensionFunctionalTestCase<T extends ComponentModel>
extends AbstractExtensionFunctionalTestCase {
    protected static final String METADATA_TEST = "metadata-tests.xml";
    protected static final String DSQL_QUERY = "dsql:SELECT id FROM Circle WHERE (diameter < 18)";
    protected static final String METADATA_TEST_STATIC_NO_REF_CONFIGURATION = "metadata-tests-static-no-ref-configuration.xml";
    protected static final String METADATA_TEST_DYNAMIC_NO_REF_CONFIGURATION = "metadata-tests-dynamic-no-ref-configuration.xml";
    protected static final String METADATA_TEST_DYNAMIC_IMPLICIT_CONFIGURATION = "metadata-tests-dynamic-implicit-configuration.xml";
    protected static final String CONTENT_METADATA_WITH_KEY_ID = "contentMetadataWithKeyId";
    protected static final String OUTPUT_METADATA_WITH_KEY_ID = "outputMetadataWithKeyId";
    protected static final String CONTENT_AND_OUTPUT_METADATA_WITH_KEY_ID = "contentAndOutputMetadataWithKeyId";
    protected static final String OUTPUT_ONLY_WITHOUT_CONTENT_PARAM = "outputOnlyWithoutContentParam";
    protected static final String CONTENT_ONLY_IGNORES_OUTPUT = "contentOnlyIgnoresOutput";
    protected static final String CONTENT_METADATA_WITHOUT_KEY_ID = "contentMetadataWithoutKeyId";
    protected static final String OUTPUT_METADATA_WITHOUT_KEY_PARAM = "outputMetadataWithoutKeyId";
    protected static final String CONTENT_AND_OUTPUT_METADATA_WITHOUT_KEY_ID = "contentAndOutputMetadataWithoutKeyId";
    protected static final String CONTENT_METADATA_WITHOUT_KEYS_WITH_KEY_ID = "contentMetadataWithoutKeysWithKeyId";
    protected static final String OUTPUT_METADATA_WITHOUT_KEYS_WITH_KEY_ID = "outputMetadataWithoutKeysWithKeyId";
    protected static final String CONTENT_AND_OUTPUT_CACHE_RESOLVER = "contentAndOutputWithCacheResolver";
    protected static final String CONTENT_AND_OUTPUT_CACHE_RESOLVER_WITH_ALTERNATIVE_CONFIG = "contentAndOutputWithCacheResolverWithSpecificConfig";
    protected static final String QUERY_FLOW = "queryOperation";
    protected static final String NATIVE_QUERY_FLOW = "nativeQueryOperation";
    protected static final String CONTENT_ONLY_CACHE_RESOLVER = "contentOnlyCacheResolver";
    protected static final String OUTPUT_AND_METADATA_KEY_CACHE_RESOLVER = "outputAndMetadataKeyCacheResolver";
    protected static final String SOURCE_METADATA = "sourceMetadata";
    protected static final String SOURCE_METADATA_WITH_MULTILEVEL = "sourceMetadataWithMultilevel";
    protected static final String SHOULD_INHERIT_OPERATION_RESOLVERS = "shouldInheritOperationResolvers";
    protected static final String SHOULD_INHERIT_EXTENSION_RESOLVERS = "shouldInheritExtensionResolvers";
    protected static final String SHOULD_INHERIT_OPERATION_PARENT_RESOLVERS = "shouldInheritOperationParentResolvers";
    protected static final String SIMPLE_MULTILEVEL_KEY_RESOLVER = "simpleMultiLevelKeyResolver";
    protected static final String INCOMPLETE_MULTILEVEL_KEY_RESOLVER = "incompleteMultiLevelKeyResolver";
    protected static final String TYPE_WITH_DECLARED_SUBTYPES_METADATA = "typeWithDeclaredSubtypesMetadata";
    protected static final String RESOLVER_WITH_DYNAMIC_CONFIG = "resolverWithDynamicConfig";
    protected static final String RESOLVER_WITH_IMPLICIT_DYNAMIC_CONFIG = "resolverWithImplicitDynamicConfig";
    protected static final String RESOLVER_WITH_IMPLICIT_STATIC_CONFIG = "resolverWithImplicitStaticConfig";
    protected static final String OUTPUT_ATTRIBUTES_WITH_DYNAMIC_METADATA = "outputAttributesWithDynamicMetadata";
    protected static final String OUTPUT_ATTRIBUTES_WITH_DECLARED_SUBTYPES_METADATA = "outputAttributesWithDeclaredSubtypesMetadata";
    protected static final String RESOLVER_CONTENT_WITH_CONTEXT_CLASSLOADER = "resolverContentWithContextClassLoader";
    protected static final String RESOLVER_OUTPUT_WITH_CONTEXT_CLASSLOADER = "resolverOutputWithContextClassLoader";
    protected static final String ENUM_METADATA_KEY = "enumMetadataKey";
    protected static final String BOOLEAN_METADATA_KEY = "booleanMetadataKey";
    protected static final String METADATA_KEY_DEFAULT_VALUE = "metadataKeyDefaultValue";
    protected static final String MULTILEVEL_METADATA_KEY_DEFAULT_VALUE = "multilevelMetadataKeyDefaultValue";
    protected static final String OUTPUT_AND_MULTIPLE_INPUT_WITH_KEY_ID = "outputAndMultipleInputWithKeyId";
    protected static final String CONTINENT = "continent";
    protected static final String COUNTRY = "country";
    protected static final String CITY = "city";
    protected static final MetadataKey PERSON_METADATA_KEY = MetadataKeyBuilder.newKey((String)"PERSON").build();
    protected static final MetadataKey CAR_KEY = MetadataKeyBuilder.newKey((String)"CAR").build();
    protected static final MetadataKey LOCATION_MULTILEVEL_KEY = MultilevelMetadataKeyBuilder.newKey((String)"AMERICA", (String)"continent").withChild(MultilevelMetadataKeyBuilder.newKey((String)"USA", (String)"country").withChild((MetadataKeyBuilder)MultilevelMetadataKeyBuilder.newKey((String)"SFO", (String)"city"))).build();
    protected static final NullMetadataKey NULL_METADATA_KEY = new NullMetadataKey();
    protected static final ClassTypeLoader TYPE_LOADER = ExtensionsTestUtils.TYPE_LOADER;
    protected MetadataType personType;
    protected Location location;
    protected Event event;
    protected MetadataService metadataService;
    protected ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    protected BaseTypeBuilder typeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA);
    protected MetadataComponentDescriptorProvider<T> provider;
    protected ResolutionType resolutionType;

    MetadataExtensionFunctionalTestCase(ResolutionType resolutionType) {
        this.resolutionType = resolutionType;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({ResolutionType.EXPLICIT_RESOLUTION}, {ResolutionType.DSL_RESOLUTION});
    }

    @Before
    public void setup() throws Exception {
        this.event = MetadataExtensionFunctionalTestCase.eventBuilder().message(Message.of((Object)"")).build();
        this.metadataService = (MetadataService)muleContext.getRegistry().lookupObject(MuleMetadataService.class);
        this.personType = TestMetadataResolverUtils.getMetadata((String)PERSON_METADATA_KEY.getId());
    }

    protected boolean isDisposeContextPerClass() {
        return true;
    }

    MetadataResult<ComponentMetadataDescriptor<T>> getComponentDynamicMetadata(MetadataKey key) {
        Preconditions.checkArgument((this.location != null ? 1 : 0) != 0, (String)"Unable to resolve Metadata. The location has not been configured.");
        return this.provider.resolveDynamicMetadata(this.metadataService, this.location, key);
    }

    ComponentMetadataDescriptor getSuccessComponentDynamicMetadata() {
        return this.getSuccessComponentDynamicMetadata(PERSON_METADATA_KEY);
    }

    ComponentMetadataDescriptor<T> getSuccessComponentDynamicMetadataWithKey(MetadataKey key) {
        return this.getSuccessComponentDynamicMetadata(key, this::assertResolvedKey);
    }

    ComponentMetadataDescriptor<T> getSuccessComponentDynamicMetadata(MetadataKey key) {
        return this.getSuccessComponentDynamicMetadata(key, (a, b) -> {});
    }

    private ComponentMetadataDescriptor<T> getSuccessComponentDynamicMetadata(MetadataKey key, BiConsumer<MetadataResult<ComponentMetadataDescriptor<T>>, MetadataKey> assertKeys) {
        MetadataResult<ComponentMetadataDescriptor<T>> componentMetadata = this.getComponentDynamicMetadata(key);
        String msg = componentMetadata.getFailures().stream().map(f -> "Failure: " + f.getMessage()).collect(Collectors.joining(", "));
        Assert.assertThat((String)msg, (Object)componentMetadata.isSuccess(), (Matcher)Is.is((Object)true));
        assertKeys.accept(componentMetadata, key);
        return (ComponentMetadataDescriptor)componentMetadata.get();
    }

    void assertMetadataFailure(MetadataFailure failure, String msgContains, FailureCode failureCode, String traceContains, MetadataComponent failingComponent) {
        this.assertMetadataFailure(failure, msgContains, failureCode, traceContains, failingComponent, "");
    }

    void assertMetadataFailure(MetadataFailure failure, String msgContains, FailureCode failureCode, String traceContains, MetadataComponent failingComponent, String failingElement) {
        Assert.assertThat((Object)failure.getFailureCode(), (Matcher)Is.is((Object)failureCode));
        if (!StringUtils.isBlank((String)msgContains)) {
            Assert.assertThat((Object)failure.getMessage(), (Matcher)Matchers.containsString((String)msgContains));
        }
        if (!StringUtils.isBlank((String)traceContains)) {
            Assert.assertThat((Object)failure.getReason(), (Matcher)Matchers.containsString((String)traceContains));
        }
        Assert.assertThat((Object)failure.getFailingComponent(), (Matcher)Is.is((Object)failingComponent));
        if (!StringUtils.isBlank((String)failingElement)) {
            Assert.assertThat((Object)failure.getFailingElement().isPresent(), (Matcher)Is.is((Object)true));
            Assert.assertThat(failure.getFailingElement().get(), (Matcher)Is.is((Object)failingElement));
        }
    }

    void assertExpectedOutput(ComponentModel model, Type payloadType, Type attributesType) {
        this.assertExpectedOutput(model.getOutput(), model.getOutputAttributes(), TYPE_LOADER.load(payloadType), TYPE_LOADER.load(attributesType));
    }

    void assertExpectedOutput(ComponentModel model, MetadataType payloadType, Type attributesType) {
        this.assertExpectedOutput(model.getOutput(), model.getOutputAttributes(), payloadType, TYPE_LOADER.load(attributesType));
    }

    void assertExpectedOutput(ComponentModel model, MetadataType payloadType, MetadataType attributesType) {
        this.assertExpectedOutput(model.getOutput(), model.getOutputAttributes(), payloadType, attributesType);
    }

    void assertExpectedOutput(OutputModel output, OutputModel attributes, MetadataType payloadType, MetadataType attributesType) {
        this.assertExpectedType(output.getType(), payloadType);
        this.assertExpectedType(attributes.getType(), attributesType);
    }

    private void assertExpectedType(MetadataType type, MetadataType expectedType) {
        Assert.assertThat((Object)type, (Matcher)Is.is((Object)expectedType));
    }

    protected void assertExpectedType(Typed type, Type expectedType) {
        Assert.assertThat((Object)type.getType(), (Matcher)Is.is((Object)TYPE_LOADER.load(expectedType)));
    }

    protected void assertExpectedType(Typed typedModel, MetadataType expectedType, boolean isDynamic) {
        Assert.assertThat((Object)typedModel.getType(), (Matcher)Is.is((Object)expectedType));
        Assert.assertThat((Object)typedModel.hasDynamicType(), (Matcher)Is.is((Object)isDynamic));
    }

    protected <T extends ComponentModel> void assertResolvedKey(MetadataResult<ComponentMetadataDescriptor<T>> result, MetadataKey metadataKey) {
        Assert.assertThat((Object)((ComponentMetadataDescriptor)result.get()).getMetadataAttributes().getKey().isPresent(), (Matcher)Is.is((Object)true));
        MetadataKey resultKey = (MetadataKey)((ComponentMetadataDescriptor)result.get()).getMetadataAttributes().getKey().get();
        this.assertSameKey(metadataKey, resultKey);
        MetadataKey child = metadataKey.getChilds().stream().findFirst().orElseGet(() -> null);
        MetadataKey otherChild = resultKey.getChilds().stream().findFirst().orElseGet(() -> null);
        while (child != null && otherChild != null) {
            this.assertSameKey(child, otherChild);
            child = child.getChilds().stream().findFirst().orElseGet(() -> null);
            otherChild = otherChild.getChilds().stream().findFirst().orElseGet(() -> null);
        }
        Assert.assertThat((Object)(child == null && otherChild == null ? 1 : 0), (Matcher)Is.is((Object)true));
    }

    private void assertSameKey(MetadataKey metadataKey, MetadataKey resultKey) {
        Assert.assertThat((Object)resultKey.getId(), (Matcher)Is.is((Object)metadataKey.getId()));
        Assert.assertThat((Object)resultKey.getChilds(), (Matcher)Matchers.hasSize((int)metadataKey.getChilds().size()));
    }

    public Set<MetadataKey> getKeysFromContainer(MetadataKeysContainer metadataKeysContainer) {
        return (Set)metadataKeysContainer.getKeys((String)metadataKeysContainer.getCategories().iterator().next()).get();
    }

    public void assertSuccessResult(MetadataResult<?> result) {
        Assert.assertThat((Object)result.getFailures(), (Matcher)Is.is((Matcher)Matchers.empty()));
        String failures = result.getFailures().stream().map(Object::toString).collect(Collectors.joining(", "));
        Assert.assertThat((String)("Expecting success but this failure/s result/s found:\n " + failures), (Object)result.isSuccess(), (Matcher)Is.is((Object)true));
    }

    void assertFailureResult(MetadataResult<?> result, int failureNumber) {
        Assert.assertThat((Object)result.getFailures(), (Matcher)Matchers.hasSize((int)failureNumber));
        Assert.assertThat((String)"Expecting failure but a success result found", (Object)result.isSuccess(), (Matcher)Is.is((Object)false));
    }

    static interface MetadataComponentDescriptorProvider<T extends ComponentModel> {
        public MetadataResult<ComponentMetadataDescriptor<T>> resolveDynamicMetadata(MetadataService var1, Location var2, MetadataKey var3);
    }

    public static enum ResolutionType {
        EXPLICIT_RESOLUTION,
        DSL_RESOLUTION;

    }
}

