/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.nb;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatcher;
import org.mule.functional.junit4.FlowRunner;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Pipeline;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.test.marvel.ironman.IronMan;
import org.mule.test.marvel.model.MissileProofVillain;
import org.mule.test.marvel.model.Villain;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

public class NonBlockingOperationsTestCase
extends AbstractExtensionFunctionalTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    protected String getConfigFile() {
        return "iron-man-config.xml";
    }

    @Test
    public void nonBlockingConnectedOperation() throws Exception {
        this.fireMissileAndAssert("fireMissile");
    }

    @Test
    public void failingNonBlockingConnectedOperation() throws Exception {
        final Processor operation = (Processor)((Pipeline)this.getFlowConstruct("fireMissile")).getMessageProcessors().get(1);
        this.expectedException.expect(CoreMatchers.instanceOf(MessagingException.class));
        this.expectedException.expect((Matcher)new ArgumentMatcher<Object>(){

            public boolean matches(Object o) {
                return ((MessagingException)o).getFailingMessageProcessor() == operation;
            }
        });
        this.expectedException.expectMessage("Missile proof");
        this.expectedException.expectCause(CoreMatchers.instanceOf(UnsupportedOperationException.class));
        MissileProofVillain villain = new MissileProofVillain();
        ((FlowRunner)this.flowRunner("fireMissile").withPayload((Object)villain)).run();
        Assert.assertThat((Object)villain.isAlive(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void nonBlockingOperationReconnection() throws Exception {
        this.fireMissileAndAssert("warMachineFireMissile");
        IronMan warMachine = this.getIronMan("warMachine");
        Assert.assertThat((Object)warMachine.getMissilesFired(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void voidNonBlockingOperation() throws Exception {
        IronMan ironMan = this.getIronMan("ironMan");
        this.flowRunner("computeFlightPlan").run();
        Assert.assertThat((Object)ironMan.getFlightPlan(), (Matcher)CoreMatchers.is((Object)"Go Straight"));
    }

    private IronMan getIronMan(String name) throws Exception {
        return (IronMan)ExtensionsTestUtils.getConfigurationInstanceFromRegistry((String)name, (Event)MuleExtensionUtils.getInitialiserEvent(), (MuleContext)muleContext).getValue();
    }

    private void fireMissileAndAssert(String flowName) throws Exception {
        Villain villain = new Villain();
        String result = (String)((FlowRunner)this.flowRunner(flowName).withPayload((Object)villain)).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)villain.isAlive(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)"KABOOM!"));
    }
}

