/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.operation;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.functional.junit4.FlowRunner;
import org.mule.runtime.core.api.Event;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class XmlHintsFunctionalTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final String MEAT = "Nice, juicy and tasty meat";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    protected String getConfigFile() {
        return "vegan-xml-hints-config.xml";
    }

    protected boolean isDisposeContextPerClass() {
        return true;
    }

    @Test
    public void fruitOnExpression() throws Exception {
        Event event = this.eatFromExpression(new Apple());
        Assert.assertThat((Object)this.getPayloadAsString(event.getMessage()), (Matcher)Matchers.equalTo((Object)("tasty " + Apple.class.getSimpleName())));
    }

    @Test
    public void stringOnExpression() throws Exception {
        this.expectMeatRejection();
        this.eatFromExpression(MEAT);
    }

    @Test
    public void fixedStringValue() throws Exception {
        this.expectMeatRejection();
        this.flowRunner("eatFixedMeat").run();
    }

    @Test
    public void eatBlank() throws Exception {
        this.expectedException.expectMessage(Matchers.containsString((String)"I SHALL NEVER EAT "));
        this.flowRunner("eatBlank").run();
    }

    @Test
    public void eatPealed() throws Exception {
        Banana banana = (Banana)this.flowRunner("eatPealedBanana").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)banana.isBitten(), (Matcher)CoreMatchers.is((Object)true));
    }

    private void expectMeatRejection() {
        this.expectedException.expectMessage(Matchers.containsString((String)"I SHALL NEVER EAT Nice, juicy and tasty meat"));
    }

    private Event eatFromExpression(Object value) throws Exception {
        return ((FlowRunner)this.flowRunner("eatFromExpression").withPayload(value)).run();
    }
}

