/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.source;

import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.exception.Errors;
import org.mule.tck.junit4.matcher.ErrorTypeMatcher;
import org.mule.tck.junit4.matcher.IsEmptyOptional;
import org.mule.tck.probe.PollingProber;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.heisenberg.extension.HeisenbergSource;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class HeisenbergMessageSourceTestCase
extends AbstractExtensionFunctionalTestCase {
    public static final int TIMEOUT_MILLIS = 50000;
    public static final int POLL_DELAY_MILLIS = 100;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    protected String getConfigFile() {
        return "heisenberg-source-config.xml";
    }

    @Before
    public void setUp() throws Exception {
        HeisenbergExtension.sourceTimesStarted = 0;
        HeisenbergSource.receivedGroupOnSource = false;
        HeisenbergSource.receivedInlineOnError = false;
        HeisenbergSource.receivedInlineOnSuccess = false;
        HeisenbergSource.executedOnSuccess = false;
        HeisenbergSource.executedOnError = false;
        HeisenbergSource.executedOnTerminate = false;
        HeisenbergSource.error = Optional.empty();
        HeisenbergSource.gatheredMoney = 0L;
    }

    @Test
    public void source() throws Exception {
        this.startFlow("source");
        this.assertSourceCompleted();
    }

    protected void assertSourceCompleted() {
        PollingProber.probe((long)50000L, (long)100L, () -> HeisenbergSource.gatheredMoney > 100L && HeisenbergSource.receivedGroupOnSource && HeisenbergSource.receivedInlineOnSuccess);
    }

    @Test
    public void onException() throws Exception {
        this.startFlow("sourceFailed");
        this.assertSourceFailed();
    }

    protected void assertSourceFailed() {
        PollingProber.probe((long)50000L, (long)100L, () -> HeisenbergSource.gatheredMoney == -1L && HeisenbergSource.receivedGroupOnSource && HeisenbergSource.receivedInlineOnError);
    }

    @Test
    public void enrichExceptionOnStart() throws Exception {
        this.expectedException.expectMessage("Enriched Connection Exception: corePoolSize cannot be a negative value");
        this.startFlow("sourceFailedOnStart");
    }

    @Test
    public void reconnectWithEnrichedException() throws Exception {
        this.startFlow("sourceFailedOnRuntime");
        PollingProber.probe((long)50000L, (long)100L, () -> HeisenbergExtension.sourceTimesStarted > 2);
    }

    @Test
    public void sourceOnSuccessCallsOnTerminate() throws Exception {
        this.startFlow("source");
        PollingProber.probe((long)50000L, (long)100L, () -> this.assertState(true, false, true));
        MatcherAssert.assertThat((Object)HeisenbergSource.terminateStatus, (Matcher)CoreMatchers.is((Object)HeisenbergSource.TerminateStatus.SUCCESS));
        MatcherAssert.assertThat((Object)HeisenbergSource.error, (Matcher)IsEmptyOptional.empty());
    }

    @Test
    public void sourceFailsOnSuccessParametersCallsOnErrorAndOnTerminate() throws Exception {
        this.startFlow("sourceWithInvalidSuccessParameter");
        PollingProber.probe((long)50000L, (long)100L, () -> this.assertState(false, true, true));
        MatcherAssert.assertThat((Object)HeisenbergSource.terminateStatus, (Matcher)CoreMatchers.is((Object)HeisenbergSource.TerminateStatus.SUCCESS));
        MatcherAssert.assertThat((Object)HeisenbergSource.error, (Matcher)IsEmptyOptional.empty());
    }

    @Test
    public void sourceFailsOnSuccessBodyCallsOnErrorAndOnTerminate() throws Exception {
        this.startFlow("sourceFailsOnSuccessBodyCallsOnErrorAndOnTerminate");
        PollingProber.probe((long)50000L, (long)100L, () -> this.assertState(true, true, true));
        MatcherAssert.assertThat((Object)HeisenbergSource.terminateStatus, (Matcher)CoreMatchers.is((Object)HeisenbergSource.TerminateStatus.SUCCESS));
        MatcherAssert.assertThat((Object)HeisenbergSource.error, (Matcher)IsEmptyOptional.empty());
    }

    @Test
    public void sourceFailsOnSuccessAndOnErrorParametersCallsOnTerminate() throws Exception {
        this.startFlow("sourceWithInvalidSuccessAndErrorParameters");
        PollingProber.probe((long)50000L, (long)100L, () -> this.assertState(false, false, true));
        MatcherAssert.assertThat((Object)HeisenbergSource.terminateStatus, (Matcher)CoreMatchers.is((Object)HeisenbergSource.TerminateStatus.ERROR_INVOKE));
        Optional optionalError = HeisenbergSource.error;
        MatcherAssert.assertThat((Object)optionalError, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)IsEmptyOptional.empty())));
        MatcherAssert.assertThat((Object)((Error)optionalError.get()).getErrorType(), (Matcher)CoreMatchers.is((Matcher)ErrorTypeMatcher.errorType((ComponentIdentifier)Errors.ComponentIdentifiers.SOURCE_ERROR_RESPONSE_GENERATE)));
    }

    @Test
    public void sourceFailsInsideOnErrorAndCallsOnTerminate() throws Exception {
        this.startFlow("sourceFailsInsideOnError");
        PollingProber.probe((long)50000L, (long)100L, () -> this.assertState(false, true, true));
        MatcherAssert.assertThat((Object)HeisenbergSource.terminateStatus, (Matcher)CoreMatchers.is((Object)HeisenbergSource.TerminateStatus.ERROR_BODY));
        Optional optionalError = HeisenbergSource.error;
        MatcherAssert.assertThat((Object)optionalError, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)IsEmptyOptional.empty())));
        MatcherAssert.assertThat((Object)((Error)optionalError.get()).getErrorType(), (Matcher)CoreMatchers.is((Matcher)ErrorTypeMatcher.errorType((ComponentIdentifier)Errors.ComponentIdentifiers.SOURCE_ERROR_RESPONSE_SEND)));
    }

    @Test
    public void failureInFlowCallsOnErrorDirectlyAndHandlesItCorrectly() throws Exception {
        this.startFlow("failureInFlowCallsOnErrorDirectly");
        PollingProber.probe((long)50000L, (long)100L, () -> this.assertState(false, true, true));
    }

    @Test
    public void failureInFlowCallsOnErrorDirectlyAndFailsHandlingIt() throws Exception {
        this.startFlow("failureInFlowCallsOnErrorDirectlyAndFailsHandlingIt");
        PollingProber.probe((long)50000L, (long)100L, () -> this.assertState(false, false, true));
        MatcherAssert.assertThat((Object)HeisenbergSource.terminateStatus, (Matcher)CoreMatchers.is((Object)HeisenbergSource.TerminateStatus.ERROR_INVOKE));
        Optional optionalError = HeisenbergSource.error;
        MatcherAssert.assertThat((Object)optionalError, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)IsEmptyOptional.empty())));
        MatcherAssert.assertThat((Object)((Error)optionalError.get()).getErrorType(), (Matcher)CoreMatchers.is((Matcher)ErrorTypeMatcher.errorType((ComponentIdentifier)Errors.ComponentIdentifiers.SOURCE_ERROR_RESPONSE_GENERATE)));
    }

    protected void startFlow(String flowName) throws Exception {
        ((Flow)this.getFlowConstruct(flowName)).start();
    }

    private boolean assertState(boolean executedOnSuccess, boolean executedOnError, boolean executedOnTerminate) {
        return HeisenbergSource.executedOnSuccess == executedOnSuccess && HeisenbergSource.executedOnError == executedOnError && HeisenbergSource.executedOnTerminate == executedOnTerminate;
    }
}

