/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.source;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleEventContext;
import org.mule.runtime.core.api.lifecycle.Callable;
import org.mule.runtime.core.api.util.concurrent.Latch;
import org.mule.test.heisenberg.extension.model.types.DEAOfficerAttributes;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class ListOfMessagesSourceTestCase
extends AbstractExtensionFunctionalTestCase
implements Callable {
    private static AtomicReference<List<Message>> capturedPayload = new AtomicReference<Object>(null);
    private static Latch latch = new Latch();

    protected String getConfigFile() {
        return "heisenberg-source-list-config.xml";
    }

    protected void doTearDown() throws Exception {
        capturedPayload = null;
        latch = null;
        super.doTearDown();
    }

    public Object onCall(MuleEventContext eventContext) throws Exception {
        List payload = (List)eventContext.getEvent().getMessage().getPayload().getValue();
        if (capturedPayload.compareAndSet(null, payload)) {
            latch.release();
        }
        return payload;
    }

    @Test
    public void listenMessages() throws Exception {
        Assert.assertThat((Object)latch.await(5L, TimeUnit.SECONDS), (Matcher)Matchers.is((Object)true));
        List<Message> payload = capturedPayload.get();
        Assert.assertThat(payload, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat(payload, (Matcher)Matchers.hasSize((int)5));
        for (Message message : payload) {
            Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(String.class)));
            Assert.assertThat((Object)message.getAttributes().getValue(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(DEAOfficerAttributes.class)));
        }
    }
}

