/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.streaming;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.junit4.FlowRunner;
import org.mule.runtime.core.api.Event;
import org.mule.test.module.extension.streaming.AbstractStreamingExtensionTestCase;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;

@Features(value={"Streaming"})
@Stories(value={"Object Streaming"})
public class ObjectStreamingExtensionTestCase
extends AbstractStreamingExtensionTestCase {
    private static final int DATA_SIZE = 100;
    private List<String> data;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.data = new ArrayList<String>(100);
        for (int i = 0; i < 100; ++i) {
            this.data.add(RandomStringUtils.randomAlphabetic((int)100));
        }
    }

    protected String getConfigFile() {
        return "objects-streaming-extension-config.xml";
    }

    @Test
    @Description(value="Consume an object stream")
    public void getObjectStream() throws Exception {
        this.assertStreamMatchesData("getStream");
    }

    @Test
    @Description(value="Operation is configured not to stream")
    public void operationWithDisabledStreaming() throws Exception {
        this.assertStreamMatchesData("getStreamWithoutStreaming");
    }

    @Test
    @Description(value="Consume a stream generated in a transaction")
    public void getStreamInTx() throws Exception {
        this.assertStreamMatchesData("getStreamInTx");
    }

    @Test(expected=Exception.class)
    @Description(value="All cursors closed when the flow fails")
    public void allStreamsClosedInCaseOfException() throws Exception {
        ((FlowRunner)this.flowRunner("crashCar").withPayload(this.data)).run();
    }

    @Test(expected=Exception.class)
    @Description(value="All cursors closed when the flow fails in a transaction")
    public void allStreamsClosedInCaseOfExceptionInTx() throws Exception {
        ((FlowRunner)this.flowRunner("crashCarTx").withPayload(this.data)).run();
    }

    private List<String> getStream(String flowName) throws Exception {
        Event result = ((FlowRunner)this.flowRunner(flowName).withPayload(this.data)).run();
        return (List)result.getMessage().getPayload().getValue();
    }

    private void assertStreamMatchesData(String flowName) throws Exception {
        List<String> actual = this.getStream(flowName);
        Assert.assertThat(actual, (Matcher)CoreMatchers.equalTo(this.data));
    }
}

