/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.transaction;

import java.util.Collection;
import java.util.Iterator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.junit4.FlowRunner;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.transactional.connection.TestLocalTransactionalConnection;

public class TransactionalOperationTestCase
extends AbstractExtensionFunctionalTestCase {
    protected String getConfigFile() {
        return "transaction-config.xml";
    }

    @Test
    public void commited() throws Exception {
        ((FlowRunner)this.flowRunner("commitLocalTx").withPayload((Object)"")).run();
    }

    @Test
    public void rolledBack() throws Exception {
        ((FlowRunner)this.flowRunner("rollbackLocalTx").withPayload((Object)"")).run();
    }

    @Test
    public void executeTransactionless() throws Exception {
        TestLocalTransactionalConnection connection = (TestLocalTransactionalConnection)((FlowRunner)this.flowRunner("executeTransactionless").withPayload((Object)"")).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)connection.isTransactionBegun(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)connection.isTransactionCommited(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)connection.isTransactionRolledback(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void localTxDoesntSupportMultipleResources() throws Exception {
        MessagingException exception = this.flowRunner("localTxDoesntSupportMultipleResources").runExpectingException();
        Error error = (Error)exception.getEvent().getError().get();
        MatcherAssert.assertThat((Object)error.getDescription(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.containsString((String)"the current transaction doesn't support it and could not be bound")));
        MatcherAssert.assertThat((Object)error.getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(TransactionException.class)));
    }

    @Test
    public void localTxSupportsMultipleOperationsFromSameResource() throws Exception {
        this.flowRunner("localTxSupportsMultipleOperationsFromSameResource").run();
    }

    @Test
    public void pagedOperationInTx() throws Exception {
        Event event = this.flowRunner("pagedOperationInTx").run();
        Collection accumulator = (Collection)event.getVariable("accumulator").getValue();
        Assert.assertThat((Object)accumulator, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)accumulator, (Matcher)Matchers.hasSize((int)2));
        Iterator it = accumulator.iterator();
        Integer id1 = (Integer)it.next();
        Integer id2 = (Integer)it.next();
        Assert.assertThat((Object)id1, (Matcher)CoreMatchers.equalTo((Object)id2));
    }

    @Test
    public void pagedOperationWithoutTx() throws Exception {
        Event event = this.flowRunner("pagedOperationWithoutTx").run();
        Collection accumulator = (Collection)event.getVariable("accumulator").getValue();
        Assert.assertThat((Object)accumulator, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)accumulator, (Matcher)Matchers.hasSize((int)2));
        Iterator it = accumulator.iterator();
        Integer id1 = (Integer)it.next();
        Integer id2 = (Integer)it.next();
        Assert.assertThat((Object)id1, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)id2)));
    }
}

