/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.typed.value;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Test;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.tck.junit4.matcher.DataTypeMatcher;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.heisenberg.extension.model.DifferedKnockableDoor;
import org.mule.test.heisenberg.extension.model.KnockeableDoor;
import org.mule.test.module.extension.typed.value.AbstractTypedValueTestCase;
import org.mule.test.typed.value.extension.extension.SimplePojo;
import org.mule.test.typed.value.extension.extension.TypedValueSource;
import org.mule.test.vegan.extension.VeganProductInformation;

public class TypedValueParameterOperationExecutionTestCase
extends AbstractTypedValueTestCase {
    private static final String STRING_VALUE = "string";
    private static final String JSON_OBJECT = "{\n  \"a\": \"json value\"\n}";
    private static final String THIS_IS_A_STRING = "This is a string";

    protected String[] getConfigFiles() {
        return new String[]{"typed-value-config.xml"};
    }

    @Override
    protected boolean isDisposeContextPerClass() {
        return true;
    }

    @After
    public void cleanUp() {
        TypedValueSource.onSuccessValue = null;
    }

    @Test
    public void typedValueForString() throws Exception {
        this.runAndAssertTypedValue("typedValueForString", THIS_IS_A_STRING, WILDCARD, null);
    }

    @Test
    public void typedValueForStringFromByteArray() throws Exception {
        this.runAndAssertTypedValue("typedValueForStringFromByteArray", THIS_IS_A_STRING, WILDCARD, null);
    }

    @Test
    public void typedValueForStringWithDefaultValue() throws Exception {
        this.runAndAssertTypedValue("typedValueForStringWithDefaultValue", "This is a default string", MediaType.ANY, null);
    }

    @Test
    public void typedValueForStringList() throws Exception {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(STRING_VALUE);
        strings.add(STRING_VALUE);
        this.runAndAssertTypedValue("typedValueForStringList", strings, WILDCARD, null);
    }

    @Test
    public void typedValueForStringListAsChild() throws Exception {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(STRING_VALUE);
        strings.add(STRING_VALUE);
        this.runAndAssertTypedValue("typedValueForStringListAsChild", strings, MediaType.ANY, null);
    }

    @Test
    public void typedValueForStringMap() throws Exception {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(STRING_VALUE, STRING_VALUE);
        this.runAndAssertTypedValue("typedValueForStringMap", map, WILDCARD, null);
    }

    @Test
    public void typedValueForStringMapAsChild() throws Exception {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(STRING_VALUE, STRING_VALUE);
        this.runAndAssertTypedValue("typedValueForStringMapAsChild", map, MediaType.ANY, null);
    }

    @Test
    public void typedValueForDoorAsChild() throws Exception {
        this.runAndAssertTypedValue("typedValueForDoorAsChild", DOOR, MediaType.ANY, null);
    }

    @Test
    public void typedValueForDoorListAsChild() throws Exception {
        ArrayList<KnockeableDoor> doors = new ArrayList<KnockeableDoor>();
        doors.add(DOOR);
        this.runAndAssertTypedValue("typedValueForDoorListAsChild", doors, MediaType.ANY, null);
    }

    @Test
    public void typedValueForDoorMapAsChild() throws Exception {
        LinkedHashMap<String, KnockeableDoor> doors = new LinkedHashMap<String, KnockeableDoor>();
        doors.put("key", DOOR);
        this.runAndAssertTypedValue("typedValueForDoorMapAsChild", doors, MediaType.ANY, null);
    }

    @Test
    public void typedValueOperationStringMapListParameter() throws Exception {
        LinkedHashMap<String, List<String>> mapStringList = new LinkedHashMap<String, List<String>>();
        mapStringList.put("key", Collections.singletonList(STRING_VALUE));
        this.runAndAssertTypedValue("typedValueOperationStringMapListParameter", mapStringList, MediaType.ANY, null);
    }

    @Test
    public void typedValueForStringOnSourceOnSuccess() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("typedValueForStringOnSourceOnSuccess");
        flow.start();
        new PollingProber(100000L, 100L).check((Probe)new JUnitLambdaProbe(() -> TypedValueSource.onSuccessValue != null));
        this.assertTypedValue(TypedValueSource.onSuccessValue, STRING_VALUE, WILDCARD, null);
    }

    @Test
    public void typedValueForStringInsidePojo() throws Exception {
        Event event = this.flowRunner("typedValueForStringInsidePojo").run();
        DifferedKnockableDoor value = (DifferedKnockableDoor)event.getMessage().getPayload().getValue();
        this.assertTypedValue(value.getAddress(), STRING_VALUE, WILDCARD, null);
    }

    @Test
    public void typedValueForContentOnNullSafePojoWithDefaultValue() throws Exception {
        Event event = this.flowRunner("typedValueForContentOnNullSafePojoWithDefaultValue").run();
        VeganProductInformation value = (VeganProductInformation)event.getMessage().getPayload().getValue();
        this.assertTypedValue(value.getDescription(), STRING_VALUE, WILDCARD, null);
    }

    @Test
    public void typedValueForContentOnNullSafePojoWithDefaultValueWithOutDefiningPojo() throws Exception {
        Event event = this.flowRunner("typedValueForContentOnNullSafePojoWithDefaultValueWithOutDefiningPojo").run();
        VeganProductInformation value = (VeganProductInformation)event.getMessage().getPayload().getValue();
        this.assertTypedValue(value.getDescription(), STRING_VALUE, WILDCARD, null);
    }

    @Test
    public void typedValueOnContentOnNullSafeWithExplicitValues() throws Exception {
        Event event = this.flowRunner("typedValueOnContentOnNullSafeWithExplicitValues").run();
        VeganProductInformation value = (VeganProductInformation)event.getMessage().getPayload().getValue();
        this.assertTypedValue(value.getDescription(), STRING_VALUE, WILDCARD, null);
        this.assertTypedValue(value.getBrandName(), STRING_VALUE, WILDCARD, null);
        this.assertTypedValue(value.getWeight(), 5, WILDCARD, null);
    }

    @Test
    public void typedValueForObject() throws Exception {
        Event event = this.flowRunner("typedValueForObject").keepStreamsOpen().run();
        TypedValue jsonObject = (TypedValue)event.getMessage().getPayload().getValue();
        InputStream content = (InputStream)jsonObject.getValue();
        MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)content), (Matcher)CoreMatchers.is((Object)JSON_OBJECT));
        MatcherAssert.assertThat((Object)jsonObject.getDataType(), (Matcher)CoreMatchers.is((Matcher)DataTypeMatcher.like((Class)jsonObject.getDataType().getType(), (MediaType)MediaType.APPLICATION_JSON, (Charset)UTF8)));
    }

    @Test
    public void typedValueForInputStream() throws Exception {
        Event event = this.flowRunner("typedValueForInputStream").run();
        TypedValue jsonObject = (TypedValue)event.getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)((InputStream)jsonObject.getValue())), (Matcher)CoreMatchers.is((Object)JSON_OBJECT));
        MatcherAssert.assertThat((Object)jsonObject.getDataType(), (Matcher)CoreMatchers.is((Matcher)DataTypeMatcher.like((Class)jsonObject.getDataType().getType(), (MediaType)MediaType.APPLICATION_JSON, (Charset)UTF8)));
    }

    @Test
    public void typedValueOperationWithExplicitStringContent() throws Exception {
        this.runAndAssertTypedValue("typedValueOperationWithExplicitStringContent", STRING_VALUE, WILDCARD, null);
    }

    @Test
    public void typedValueOperationWithDefaultStringContent() throws Exception {
        this.runAndAssertTypedValue("typedValueOperationWithDefaultStringContent", STRING_VALUE, WILDCARD, null);
    }

    @Test
    public void typedValueOperationWithExplicitNullContent() throws Exception {
        this.runAndAssertTypedValue("typedValueOperationWithExplicitNullContent", null, MediaType.APPLICATION_JSON, UTF8);
    }

    @Test
    public void wrappedAndUnwrappedTypes() throws Exception {
        List wrappedAndUnwrappedTypes = (List)this.flowRunner("wrappedAndUnwrappedTypes").run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat(wrappedAndUnwrappedTypes.get(0), (Matcher)CoreMatchers.is((Object)"stringNotWrapped"));
        MatcherAssert.assertThat((Object)((TypedValue)wrappedAndUnwrappedTypes.get(1)).getValue(), (Matcher)CoreMatchers.is((Object)"wrappedString"));
        MatcherAssert.assertThat((Object)((SimplePojo)((TypedValue)wrappedAndUnwrappedTypes.get(2)).getValue()).getUser(), (Matcher)CoreMatchers.is((Object)"user"));
        MatcherAssert.assertThat((Object)((SimplePojo)wrappedAndUnwrappedTypes.get(3)).getUser(), (Matcher)CoreMatchers.is((Object)"user2"));
        Map mapOfComplexValues = (Map)wrappedAndUnwrappedTypes.get(4);
        Map mapOfComplexTypedValues = (Map)wrappedAndUnwrappedTypes.get(5);
        MatcherAssert.assertThat((Object)mapOfComplexValues.entrySet().size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(((Map)mapOfComplexValues.get("first")).get("pass"), (Matcher)CoreMatchers.is((Object)"pass"));
        MatcherAssert.assertThat((Object)mapOfComplexTypedValues.entrySet().size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(((Map)((TypedValue)mapOfComplexTypedValues.get("third")).getValue()).get("pass"), (Matcher)CoreMatchers.is((Object)"pass3"));
        SimplePojo group = (SimplePojo)wrappedAndUnwrappedTypes.get(6);
        MatcherAssert.assertThat((Object)group.getUser(), (Matcher)CoreMatchers.is((Object)"groupUser"));
        MatcherAssert.assertThat((Object)group.getPass(), (Matcher)CoreMatchers.is((Object)"groupPass"));
    }
}

