/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.junit4.rules.ExpectedError;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.core.api.construct.Pipeline;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.exception.MuleFatalException;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.test.heisenberg.extension.HeisenbergErrors;
import org.mule.test.heisenberg.extension.exception.HeisenbergException;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class OperationErrorHandlingTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final String HEISENBERG = "HEISENBERG";
    @Rule
    public ExpectedError expectedError = ExpectedError.none();

    protected String[] getConfigFiles() {
        return new String[]{"heisenberg-operation-error-handling-config.xml"};
    }

    @Test
    public void heisenbergThrowsAHealthErrorFromHeisenbergException() throws Exception {
        this.expectedError.expectErrorType(HEISENBERG, HeisenbergErrors.HEALTH.getType()).expectCause(CoreMatchers.instanceOf(HeisenbergException.class));
        this.flowRunner("cureCancer").run();
    }

    @Test
    public void heisenbergThrowsMessagingExceptionWithEventAndFailingProcessorPopulated() throws Exception {
        Processor operation = (Processor)((Pipeline)this.getFlowConstruct("cureCancer")).getProcessors().get(0);
        try {
            this.flowRunner("cureCancer").run();
            Assert.fail();
        }
        catch (MessagingException messagingException) {
            Assert.assertThat((Object)messagingException.getFailingComponent(), (Matcher)CoreMatchers.is((Object)operation));
            Assert.assertThat((Object)messagingException.getEvent(), (Matcher)CoreMatchers.notNullValue());
        }
    }

    @Test
    public void connectionExceptionThrowsAnConnectivityError() throws Exception {
        this.expectedError.expectErrorType(HEISENBERG, "CONNECTIVITY").expectCause(CoreMatchers.instanceOf(ConnectionException.class));
        this.flowRunner("connectionFails").run();
    }

    @Test
    public void unrecognizedExceptionIsUnknown() throws Exception {
        this.expectedError.expectErrorType("mule".toUpperCase(), "UNKNOWN").expectCause(CoreMatchers.instanceOf(HeisenbergException.class));
        this.flowRunner("unrecognizedException").run();
    }

    @Test
    public void errorIsPropagatedCorrectly() throws Exception {
        this.expectedError.expectErrorType(Errors.ComponentIdentifiers.Unhandleable.FATAL.getNamespace().toUpperCase(), Errors.ComponentIdentifiers.Unhandleable.FATAL.getName()).expectCause(CoreMatchers.instanceOf(MuleFatalException.class));
        try {
            this.flowRunner("throwError").run();
            Assert.fail((String)"Should've thrown an exception");
        }
        catch (Throwable t) {
            Throwable problem = t.getCause();
            Assert.assertThat((Object)problem, (Matcher)CoreMatchers.instanceOf(MuleFatalException.class));
            Assert.assertThat((Object)problem.getCause(), (Matcher)CoreMatchers.instanceOf(LinkageError.class));
            throw t;
        }
    }
}

