/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension;

import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mock;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.streaming.object.CursorIterator;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.test.heisenberg.extension.MoneyLaunderingOperation;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class PagedOperationExecutionTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final String SAUL_NEW_NUMBER = "123-12-3";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock
    private ConnectionManager connectionManager;

    protected String getConfigFile() {
        return "heisenberg-paged-operation-config.xml";
    }

    @Test
    public void basicPagedOperation() throws Exception {
        CursorIterator streamingIterator = this.getCursor("getPersonalInfo");
        MatcherAssert.assertThat((Object)streamingIterator.getSize(), (Matcher)Is.is((Object)11));
        while (streamingIterator.hasNext()) {
            MatcherAssert.assertThat((Object)streamingIterator.next(), (Matcher)Matchers.isIn((Collection)MoneyLaunderingOperation.INVOLVED_PEOPLE));
        }
    }

    @Test
    public void emptyPagedOperation() throws Exception {
        CursorIterator iterator = this.getCursor("emptyPagedOperation");
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)iterator.getSize(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void pagedOperationException() throws Exception {
        this.expectedException.expect(MessagingException.class);
        this.expectedException.expectCause(Is.is((Matcher)Matchers.instanceOf(ConnectionException.class)));
        this.getCursor("failingPagedOperation").next();
    }

    @Test
    public void pagedOperationUsingConnection() throws Exception {
        CursorIterator iterator = this.getCursor("pagedOperationUsingConnection");
        MatcherAssert.assertThat((Object)iterator.next().toString(), (Matcher)Matchers.containsString((String)SAUL_NEW_NUMBER));
    }

    @Test
    public void pagedOperationWithStickyConnection() throws Exception {
        CursorIterator iterator = this.getCursor("pagedOperationWithStickyConnection");
        Integer connectionId1 = (Integer)iterator.next();
        Integer connectionId2 = (Integer)iterator.next();
        MatcherAssert.assertThat((Object)connectionId1, (Matcher)Matchers.equalTo((Object)connectionId2));
    }

    private <T> CursorIterator<T> getCursor(String flowName) throws Exception {
        CursorIteratorProvider provider = (CursorIteratorProvider)this.flowRunner(flowName).keepStreamsOpen().run().getMessage().getPayload().getValue();
        return (CursorIterator)provider.openCursor();
    }
}

