/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class RoutersExecutionTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final String KILL_REASON = "I'm the one who knocks";
    @Rule
    public SystemProperty maxRedelivery = new SystemProperty("killingReason", "I'm the one who knocks");
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    protected String[] getConfigFiles() {
        return new String[]{"heisenberg-router-config.xml"};
    }

    protected boolean isDisposeContextPerClass() {
        return true;
    }

    @Test
    public void singleRouteRouter() throws Exception {
        InternalEvent internalEvent = ((FlowRunner)((FlowRunner)this.flowRunner("singleRouteRouter").withPayload((Object)"message")).withAttributes((Object)"other")).run();
        Assert.assertThat((Object)internalEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"message"));
        Assert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("newPayload")).getValue(), (Matcher)CoreMatchers.is((Object)"message"));
        Assert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("newAttributes")).getValue(), (Matcher)CoreMatchers.is((Object)"other"));
    }

    @Test
    public void twoRoutesRouterWhen() throws Exception {
        InternalEvent internalEvent = ((FlowRunner)((FlowRunner)this.flowRunner("twoRoutesRouter").withVariable("executeWhen", (Object)true)).withVariable("executeOther", (Object)false)).run();
        Assert.assertThat((Object)internalEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"mule:set-payload"));
        Assert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("newPayload")).getValue(), (Matcher)CoreMatchers.is((Object)"mule:set-payload"));
    }

    @Test
    public void twoRoutesRouterOther() throws Exception {
        InternalEvent internalEvent = ((FlowRunner)((FlowRunner)this.flowRunner("twoRoutesRouter").withVariable("executeWhen", (Object)false)).withVariable("executeOther", (Object)true)).run();
        Assert.assertThat((Object)internalEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"mule:set-payload"));
        Assert.assertThat(internalEvent.getVariables().get("newPayload"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat(internalEvent.getVariables().get("newAttributes"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void twoRoutesRouterNone() throws Exception {
        this.expectedException.expectCause(CoreMatchers.instanceOf(ConnectionException.class));
        this.expectedException.expectMessage("No route executed");
        this.runFlow("twoRoutesRouterNone");
    }

    @Test
    public void munitSpy() throws Exception {
        InternalEvent internalEvent = this.flowRunner("munitSpy").run();
        Assert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("before")).getValue(), (Matcher)CoreMatchers.is((Object)"true"));
        Assert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("after")).getValue(), (Matcher)CoreMatchers.is((Object)"true"));
    }

    @Test
    public void munitSpyNoBefore() throws Exception {
        InternalEvent internalEvent = this.flowRunner("munitSpyNoBefore").run();
        Assert.assertThat((Object)internalEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"1"));
        Assert.assertThat(internalEvent.getVariables().get("before"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("after")).getValue(), (Matcher)CoreMatchers.is((Object)"true"));
    }

    @Test
    public void munitSpyNoAfter() throws Exception {
        InternalEvent internalEvent = this.flowRunner("munitSpyNoAfter").run();
        Assert.assertThat((Object)internalEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"2"));
        Assert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("before")).getValue(), (Matcher)CoreMatchers.is((Object)"true"));
        Assert.assertThat(internalEvent.getVariables().get("after"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void munitSpyNoAttributes() throws Exception {
        InternalEvent internalEvent = this.flowRunner("munitSpyNoAttributes").run();
        Assert.assertThat((Object)internalEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat(internalEvent.getVariables().get("before"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat(internalEvent.getVariables().get("after"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

