/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class ScopeExecutionTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final String KILL_REASON = "I'm the one who knocks";
    @Rule
    public SystemProperty maxRedelivery = new SystemProperty("killingReason", "I'm the one who knocks");
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    protected String[] getConfigFiles() {
        return new String[]{"heisenberg-scope-config.xml"};
    }

    protected boolean isDisposeContextPerClass() {
        return true;
    }

    @Test
    public void verifyProcessorInitialise() throws Exception {
        this.runFlow("getChain").getMessage().getPayload().getValue();
        this.runFlow("getChain").getMessage().getPayload().getValue();
        this.runFlow("getChain").getMessage().getPayload().getValue();
        int value = (Integer)this.runFlow("getCounter").getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void verifySameProcessorInstance() throws Exception {
        Object getChainFirst = this.runFlow("getChain").getMessage().getPayload().getValue();
        Object getChainSecond = this.runFlow("getChain").getMessage().getPayload().getValue();
        Assert.assertThat((Object)getChainFirst, (Matcher)CoreMatchers.is((Matcher)IsNot.not((Matcher)CoreMatchers.sameInstance((Object)getChainSecond))));
        Object firstChain = ClassUtils.getFieldValue((Object)getChainFirst, (String)"chain", (boolean)false);
        Object secondChain = ClassUtils.getFieldValue((Object)getChainSecond, (String)"chain", (boolean)false);
        Assert.assertThat((Object)firstChain, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)secondChain)));
    }

    @Test
    public void alwaysFailsWrapperFailure() throws Exception {
        this.expectedException.expect(CoreMatchers.instanceOf(MessagingException.class));
        this.expectedException.expectCause(CoreMatchers.instanceOf(ConnectionException.class));
        this.expectedException.expectMessage("ON_ERROR_ERROR");
        this.runFlow("alwaysFailsWrapperFailure");
    }

    @Test
    public void alwaysFailsWrapperSuccess() throws Exception {
        this.expectedException.expect(CoreMatchers.instanceOf(MessagingException.class));
        this.expectedException.expectCause(CoreMatchers.instanceOf(ConnectionException.class));
        this.expectedException.expectMessage("ON_SUCCESS_ERROR");
        this.runFlow("alwaysFailsWrapperSuccess");
    }

    @Test
    public void exceptionOnCallbacksSuccess() throws Exception {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("ON_ERROR_EXCEPTION");
        this.runFlow("exceptionOnCallbacksSuccess");
    }

    @Test
    public void exceptionOnCallbacksFailure() throws Exception {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("ON_ERROR_EXCEPTION");
        this.runFlow("exceptionOnCallbacksFailure");
    }

    @Test
    @Ignore(value="MULE-13440")
    public void manyNestedOperations() throws Exception {
        InternalEvent event = this.runFlow("killMany");
        String expected = "Killed the following because I'm the one who knocks:\nbye bye, Gustavo Fring\nbye bye, Frank\nbye bye, Nazi dudes\n";
        Assert.assertThat((Object)event.getMessageAsString(muleContext), (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test
    @Ignore(value="MULE-13440")
    public void manyNestedOperationsSupportedButOnlyOneProvided() throws Exception {
        InternalEvent event = this.runFlow("killManyButOnlyOneProvided");
        String expected = "Killed the following because I'm the one who knocks:\nbye bye, Gustavo Fring\n";
        Assert.assertThat((Object)expected, (Matcher)CoreMatchers.is((Object)event.getMessageAsString(muleContext)));
    }

    @Test
    public void anything() throws Exception {
        InternalEvent event = ((FlowRunner)this.flowRunner("executeAnything").withPayload((Object)"Killed the following because I'm the one who knocks:")).run();
        String expected = "Killed the following because I'm the one who knocks:";
        Assert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test
    public void neverFailsWrapperFailingChain() throws Exception {
        InternalEvent event = this.flowRunner("neverFailsWrapperFailingChain").run();
        Assert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"ERROR"));
        Assert.assertThat((Object)((TypedValue)event.getVariables().get("varName")).getValue(), (Matcher)CoreMatchers.is((Object)"varValue"));
    }

    @Test
    public void neverFailsWrapperSuccessChain() throws Exception {
        InternalEvent event = ((FlowRunner)this.flowRunner("neverFailsWrapperSuccessChain").withVariable("newpayload", (Object)"newpayload2")).run();
        Assert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"SUCCESS"));
        Assert.assertThat((Object)((TypedValue)event.getVariables().get("varName")).getValue(), (Matcher)CoreMatchers.is((Object)"varValue"));
    }

    @Test
    public void payloadModifier() throws Exception {
        InternalEvent event = this.flowRunner("payloadModifier").run();
        Assert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"MESSAGE"));
        Assert.assertThat((Object)((TypedValue)event.getVariables().get("newPayload")).getValue(), (Matcher)CoreMatchers.is((Object)"MESSAGE"));
        Assert.assertThat((Object)((TypedValue)event.getVariables().get("newAttributes")).getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void neverFailsWrapperNoChain() throws Exception {
        InternalEvent event = this.flowRunner("neverFailsWrapperNoChain").run();
        Assert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"EMPTY"));
    }
}

