/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.config;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.petstore.extension.PetStoreClient;
import org.mule.test.petstore.extension.PetStoreConnector;

public abstract class PetStoreConnectionTestCase
extends AbstractExtensionFunctionalTestCase {
    protected static final String DEFAULT_CONFIG_NAME = "petstore";

    @Test
    public void getPets() throws Exception {
        ConfigurationInstance config = muleContext.getExtensionManager().getConfiguration(DEFAULT_CONFIG_NAME, this.testEvent());
        Assert.assertThat((Object)config, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        InternalEvent response = this.runFlow("getPets");
        List pets = (List)response.getMessage().getPayload().getValue();
        PetStoreConnector configValue = (PetStoreConnector)config.getValue();
        Assert.assertThat((Object)pets, (Matcher)Matchers.containsInAnyOrder((Object[])configValue.getPets().toArray()));
    }

    @Test
    public void verifyClient() throws Exception {
        PetStoreClient client = this.getClient();
        this.assertValidClient(client);
    }

    @Test
    public void stopAndDisconnect() throws Exception {
        PetStoreClient client = this.getClient();
        muleContext.stop();
        Assert.assertThat((Object)client.getDisconnectCount(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)client.hasActiveConnection(), (Matcher)CoreMatchers.is((Object)false));
    }

    protected PetStoreClient getClient() throws Exception {
        PetStoreClient client = (PetStoreClient)this.runFlow("getClient").getMessage().getPayload().getValue();
        Assert.assertThat((Object)client, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        return client;
    }

    protected void assertValidClient(PetStoreClient client) {
        Assert.assertThat((Object)client.getUsername(), (Matcher)CoreMatchers.is((Object)"john"));
        Assert.assertThat((Object)client.getPassword(), (Matcher)CoreMatchers.is((Object)"doe"));
        this.assertConnected(client);
        Assert.assertThat((Object)client.getConfigName(), (Matcher)CoreMatchers.equalTo((Object)this.getConfigName()));
    }

    protected void assertConnected(PetStoreClient client) {
        Assert.assertThat((Object)client.hasActiveConnection(), (Matcher)CoreMatchers.is((Object)true));
    }

    protected String getConfigName() {
        return DEFAULT_CONFIG_NAME;
    }
}

