/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.connector;

import java.nio.charset.Charset;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.petstore.extension.PetCage;

public class PetStoreDefaultEncodingTestCase
extends AbstractExtensionFunctionalTestCase {
    private String defaultEncoding;
    private String customEncoding;

    protected String getConfigFile() {
        return "petstore-default-mule-encoding.xml";
    }

    @Before
    public void setUp() {
        this.defaultEncoding = muleContext.getConfiguration().getDefaultEncoding();
        MatcherAssert.assertThat((Object)this.defaultEncoding, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.customEncoding = Charset.availableCharsets().keySet().stream().filter(encoding -> !encoding.equals(this.defaultEncoding)).findFirst().orElse(null);
        MatcherAssert.assertThat((Object)this.customEncoding, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.customEncoding, (Matcher)Matchers.is((Matcher)Matchers.not((Object)this.defaultEncoding)));
    }

    @Test
    public void configEncoding() throws Exception {
        PetCage cage = (PetCage)this.flowRunner("fieldEncoding").run().getMessage().getPayload().getValue();
        this.assertDefaultEncoding(cage.getEncoding());
    }

    @Test
    public void topLevelEncoding() throws Exception {
        this.assertDefaultEncoding((String)this.flowRunner("topLevelEncoding").run().getMessage().getPayload().getValue());
    }

    @Test
    public void argumentEncoding() throws Exception {
        this.assertDefaultEncoding((String)this.flowRunner("argumentEncoding").run().getMessage().getPayload().getValue());
    }

    @Test
    public void overrideEncoding() throws Exception {
        String flowResult = (String)((FlowRunner)this.flowRunner("overridedArgumentEncoding").withVariable("customEncoding", (Object)this.customEncoding)).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)flowResult, (Matcher)Matchers.is((Object)this.customEncoding));
    }

    private void assertDefaultEncoding(String encoding) {
        MatcherAssert.assertThat((Object)encoding, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)encoding, (Matcher)Matchers.is((Object)this.defaultEncoding));
    }
}

