/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.metadata;

import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.tck.junit4.matcher.MetadataKeyMatcher;
import org.mule.tck.message.StringAttributes;
import org.mule.test.module.extension.metadata.MetadataExtensionFunctionalTestCase;

public class SourceMetadataTestCase
extends MetadataExtensionFunctionalTestCase<SourceModel> {
    public SourceMetadataTestCase(MetadataExtensionFunctionalTestCase.ResolutionType resolutionType) {
        super(resolutionType);
        this.provider = resolutionType == MetadataExtensionFunctionalTestCase.ResolutionType.EXPLICIT_RESOLUTION ? MetadataService::getSourceMetadata : (metadataService, componentId, key) -> metadataService.getSourceMetadata(componentId);
        this.location = Location.builder().globalName("sourceMetadata").addSourcePart().build();
    }

    protected String getConfigFile() {
        return "metadata-tests.xml";
    }

    @Override
    protected boolean isDisposeContextPerClass() {
        return false;
    }

    @Test
    public void getSourceMetadataKeys() {
        MetadataResult metadataKeysResult = this.metadataService.getMetadataKeys(this.location);
        MatcherAssert.assertThat((Object)metadataKeysResult.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        Set<MetadataKey> metadataKeys = this.getKeysFromContainer((MetadataKeysContainer)metadataKeysResult.get());
        MatcherAssert.assertThat((Object)metadataKeys.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat(metadataKeys, (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{MetadataKeyMatcher.metadataKeyWithId((String)"PERSON"), MetadataKeyMatcher.metadataKeyWithId((String)"CAR"), MetadataKeyMatcher.metadataKeyWithId((String)"HOUSE")}));
    }

    @Test
    public void injectComposedMetadataKeyIdInstanceInSource() throws Exception {
        ((Flow)this.getFlowConstruct("sourceMetadataWithMultilevel")).start();
    }

    @Test
    public void injectSimpleMetadataKeyIdInstanceInSource() throws Exception {
        ((Flow)this.getFlowConstruct("sourceMetadata")).start();
    }

    @Test
    public void getSourceDynamicOutputMetadata() throws Exception {
        MetadataResult result = this.getComponentDynamicMetadata(PERSON_METADATA_KEY);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        ComponentMetadataDescriptor componentMetadata = (ComponentMetadataDescriptor)result.get();
        this.assertExpectedOutput((ConnectableComponentModel)componentMetadata.getModel(), this.personType, this.typeLoader.load(StringAttributes.class));
        MatcherAssert.assertThat(componentMetadata.getMetadataAttributes().getKey().get(), (Matcher)CoreMatchers.is((Object)PERSON_METADATA_KEY));
    }
}

