/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.operation;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.test.marvel.ironman.IronMan;
import org.mule.test.marvel.model.Villain;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

public class OperationReconnectionTestCase
extends AbstractExtensionFunctionalTestCase {
    protected String getConfigFile() {
        return "operation-reconnection-config.xml";
    }

    @Test
    public void operationReconnection() throws Exception {
        Villain villain = new Villain();
        ((FlowRunner)this.flowRunner("operationReconnection").withPayload((Object)villain)).run();
        Assert.assertThat((Object)villain.isAlive(), (Matcher)CoreMatchers.is((Object)false));
        IronMan stark = this.getIronMan();
        Assert.assertThat((Object)stark.getMissilesFired(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void defaultReconnection() throws Exception {
        Villain villain = new Villain();
        try {
            ((FlowRunner)this.flowRunner("defaultReconnection").withPayload((Object)villain)).run();
            Assert.fail((String)"Should have failed");
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)villain.isAlive(), (Matcher)CoreMatchers.is((Object)true));
            IronMan stark = this.getIronMan();
            Assert.assertThat((Object)stark.getMissilesFired(), (Matcher)CoreMatchers.is((Object)1));
        }
    }

    private IronMan getIronMan() throws Exception {
        return (IronMan)ExtensionsTestUtils.getConfigurationInstanceFromRegistry((String)"ironMan", (InternalEvent)this.testEvent(), (MuleContext)muleContext).getValue();
    }
}

