/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.values;

import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Test;
import org.mule.runtime.api.value.Value;
import org.mule.tck.junit4.matcher.ValueMatcher;
import org.mule.test.module.extension.values.AbstractValuesTestCase;

public class SourcesValuesTestCase
extends AbstractValuesTestCase {
    protected String getConfigFile() {
        return "values/sources-values.xml";
    }

    @Test
    public void singleValues() throws Exception {
        Set<Value> channels = this.getValuesFromSource("simple-source", "channel");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)3));
        MatcherAssert.assertThat(channels, this.hasValues("channel1", "channel2", "channel3"));
    }

    @Test
    public void singleValuesEnabledParameterWithConnection() throws Exception {
        Set<Value> channels = this.getValuesFromSource("source-with-connection", "channel");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)3));
        MatcherAssert.assertThat(channels, this.hasValues("connection1", "connection2", "connection3"));
    }

    @Test
    public void singleValuesEnabledParameterWithConfiguration() throws Exception {
        Set<Value> channels = this.getValuesFromSource("source-with-configuration", "channel");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)3));
        MatcherAssert.assertThat(channels, this.hasValues("config1", "config2", "config3"));
    }

    @Test
    public void singleValuesEnabledParameterWithRequiredParameters() throws Exception {
        Set<Value> channels = this.getValuesFromSource("source-with-values-with-required-parameters", "channels");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)4));
        MatcherAssert.assertThat(channels, this.hasValues("requiredInteger:2", "requiredBoolean:false", "strings:[1, 2]", "requiredString:aString"));
    }

    @Test
    public void singleValuesEnabledParameterInsideParameterGroup() throws Exception {
        Set<Value> channels = this.getValuesFromSource("source-with-values-with-required-parameter-inside-param-group", "channels");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)3));
        MatcherAssert.assertThat(channels, this.hasValues("channel1", "channel2", "channel3"));
    }

    @Test
    public void multiLevelValue() throws Exception {
        Set<Value> values = this.getValuesFromSource("source-with-multi-level-value", "values");
        ValueMatcher americaValue = ValueMatcher.valueWithId((String)"America").withDisplayName("America").withPartName("continent").withChilds(new ValueMatcher[]{ValueMatcher.valueWithId((String)"Argentina").withDisplayName("Argentina").withPartName("country").withChilds(new ValueMatcher[]{ValueMatcher.valueWithId((String)"Buenos Aires").withDisplayName("Buenos Aires").withPartName("city")})});
        MatcherAssert.assertThat(values, this.hasValues(americaValue));
    }

    @Test
    public void singleValuesWithRequiredParameterWithAlias() throws Exception {
        Set<Value> channels = this.getValuesFromSource("source-with-required-parameter-with-alias", "channels");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat(channels, this.hasValues("requiredString:dummyValue"));
    }

    @Test
    public void optionsInsideShowInDslGroup() throws Exception {
        Set<Value> values = this.getValuesFromSource("source-with-required-parameter-inside-show-in-dsl-group", "values");
        MatcherAssert.assertThat(values, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat(values, this.hasValues("anyParameter:someValue"));
    }
}

