/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.type.TypeCatalog;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.dsl.syntax.resources.spi.ExtensionSchemaGenerator;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.module.extension.api.loader.java.DefaultJavaExtensionModelLoader;
import org.mule.runtime.module.extension.internal.capability.xml.schema.DefaultExtensionSchemaGenerator;
import org.mule.runtime.module.extension.internal.loader.enricher.JavaXmlDeclarationEnricher;
import org.mule.runtime.module.extension.internal.runtime.connectivity.basic.GlobalInnerPojoConnector;
import org.mule.runtime.module.extension.internal.runtime.connectivity.basic.GlobalPojoConnector;
import org.mule.runtime.module.extension.internal.runtime.connectivity.basic.ListConnector;
import org.mule.runtime.module.extension.internal.runtime.connectivity.basic.MapConnector;
import org.mule.runtime.module.extension.internal.runtime.connectivity.basic.StringListConnector;
import org.mule.runtime.module.extension.internal.runtime.connectivity.basic.TestConnector;
import org.mule.runtime.module.extension.soap.api.loader.SoapExtensionModelLoader;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.function.extension.WeaveFunctionExtension;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.marvel.MarvelExtension;
import org.mule.test.metadata.extension.MetadataExtension;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.test.oauth.TestOAuthExtension;
import org.mule.test.petstore.extension.PetStoreConnector;
import org.mule.test.ram.RickAndMortyExtension;
import org.mule.test.soap.extension.FootballSoapExtension;
import org.mule.test.substitutiongroup.extension.SubstitutionGroupExtension;
import org.mule.test.subtypes.extension.SubTypesMappingConnector;
import org.mule.test.transactional.TransactionalExtension;
import org.mule.test.typed.value.extension.extension.TypedValueExtension;
import org.mule.test.values.extension.ValuesExtension;
import org.mule.test.vegan.extension.VeganExtension;

@SmallTest
@RunWith(value=Parameterized.class)
public class DefaultExtensionSchemaGeneratorTestCase
extends AbstractMuleTestCase {
    static final Map<String, ExtensionModel> extensionModels = new HashMap<String, ExtensionModel>();
    private static ExtensionModelLoader javaLoader = new DefaultJavaExtensionModelLoader();
    private static ExtensionModelLoader soapLoader = new SoapExtensionModelLoader();
    @Parameterized.Parameter(value=0)
    public ExtensionModel extensionUnderTest;
    @Parameterized.Parameter(value=1)
    public String expectedXSD;
    private ExtensionSchemaGenerator generator = new DefaultExtensionSchemaGenerator();
    private String expectedSchema;

    @Parameterized.Parameters(name="{1}")
    public static Collection<Object[]> data() {
        ClassLoader classLoader = DefaultExtensionSchemaGeneratorTestCase.class.getClassLoader();
        ServiceRegistry serviceRegistry = (ServiceRegistry)Mockito.mock(ServiceRegistry.class);
        Mockito.when((Object)serviceRegistry.lookupProviders(DeclarationEnricher.class, classLoader)).thenReturn(Arrays.asList(new JavaXmlDeclarationEnricher()));
        List<SchemaGeneratorTestUnit> extensions = Arrays.asList(SchemaGeneratorTestUnit.newTestUnit(javaLoader, MapConnector.class, "map.xsd"), SchemaGeneratorTestUnit.newTestUnit(javaLoader, ListConnector.class, "list.xsd"), SchemaGeneratorTestUnit.newTestUnit(javaLoader, TestConnector.class, "basic.xsd"), SchemaGeneratorTestUnit.newTestUnit(javaLoader, StringListConnector.class, "string-list.xsd"), SchemaGeneratorTestUnit.newTestUnit(javaLoader, GlobalPojoConnector.class, "global-pojo.xsd"), SchemaGeneratorTestUnit.newTestUnit(javaLoader, GlobalInnerPojoConnector.class, "global-inner-pojo.xsd"), SchemaGeneratorTestUnit.newTestUnit(javaLoader, VeganExtension.class, "vegan.xsd"), SchemaGeneratorTestUnit.newTestUnit(javaLoader, PetStoreConnector.class, "petstore.xsd"), SchemaGeneratorTestUnit.newTestUnit(javaLoader, MetadataExtension.class, "metadata.xsd"), SchemaGeneratorTestUnit.newTestUnit(javaLoader, HeisenbergExtension.class, "heisenberg.xsd"), SchemaGeneratorTestUnit.newTestUnit(javaLoader, SubstitutionGroupExtension.class, "substitutiongroup.xsd"), SchemaGeneratorTestUnit.newTestUnit(javaLoader, TransactionalExtension.class, "tx-ext.xsd"), SchemaGeneratorTestUnit.newTestUnit(javaLoader, SubTypesMappingConnector.class, "subtypes.xsd"), SchemaGeneratorTestUnit.newTestUnit(javaLoader, MarvelExtension.class, "marvel.xsd"), SchemaGeneratorTestUnit.newTestUnit(soapLoader, FootballSoapExtension.class, "soap.xsd"), SchemaGeneratorTestUnit.newTestUnit(soapLoader, RickAndMortyExtension.class, "ram.xsd"), SchemaGeneratorTestUnit.newTestUnit(javaLoader, TypedValueExtension.class, "typed-value.xsd"), SchemaGeneratorTestUnit.newTestUnit(javaLoader, TestOAuthExtension.class, "test-oauth.xsd"), SchemaGeneratorTestUnit.newTestUnit(javaLoader, WeaveFunctionExtension.class, "test-fn.xsd"), SchemaGeneratorTestUnit.newTestUnit(javaLoader, ValuesExtension.class, "values.xsd"));
        BiFunction<Class, ExtensionModelLoader, ExtensionModel> createExtensionModel = (extension, loader) -> {
            ExtensionModel model = DefaultExtensionSchemaGeneratorTestCase.loadExtension(extension, loader);
            if (extensionModels.put(model.getName(), model) != null) {
                throw new IllegalArgumentException(String.format("Extension names must be unique. Name [%s] for extension [%s] was already used", model.getName(), extension.getName()));
            }
            return model;
        };
        return extensions.stream().map(e -> new Object[]{createExtensionModel.apply(e.getExtensionClass(), e.getLoader()), e.getFileName()}).collect(Collectors.toList());
    }

    private boolean shouldUpdateExpectedFilesOnError() {
        return false;
    }

    @Before
    public void setup() throws IOException {
        this.expectedSchema = IOUtils.getResourceAsString((String)("schemas/" + this.expectedXSD), ((Object)((Object)this)).getClass());
    }

    @Test
    public void generate() throws Exception {
        String schema = this.generator.generate(this.extensionUnderTest, (DslResolvingContext)new SchemaTestDslContext());
        try {
            ExtensionsTestUtils.compareXML((String)this.expectedSchema, (String)schema);
        }
        catch (Throwable t) {
            if (this.shouldUpdateExpectedFilesOnError()) {
                File root = new File(IOUtils.getResourceAsUrl((String)("schemas/" + this.expectedXSD), ((Object)((Object)this)).getClass()).toURI()).getParentFile().getParentFile().getParentFile().getParentFile();
                File testDir = new File(root, "src/test/resources/schemas");
                File target = new File(testDir, this.expectedXSD);
                FileUtils.stringToFile((String)target.getAbsolutePath(), (String)schema);
                System.out.println(this.expectedXSD + " fixed");
            }
            throw t;
        }
    }

    public static ExtensionModel loadExtension(Class<?> clazz, ExtensionModelLoader loader) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", clazz.getName());
        params.put("version", MuleManifest.getProductVersion());
        DslResolvingContext dslResolvingContext = DslResolvingContext.getDefault(new LinkedHashSet<ExtensionModel>(extensionModels.values()));
        return loader.loadExtensionModel(clazz.getClassLoader(), dslResolvingContext, params);
    }

    static class SchemaGeneratorTestUnit {
        final ExtensionModelLoader loader;
        final Class<?> extensionClass;
        final String fileName;

        SchemaGeneratorTestUnit(ExtensionModelLoader loader, Class<?> extensionClass, String fileName) {
            this.loader = loader;
            this.extensionClass = extensionClass;
            this.fileName = fileName;
        }

        static SchemaGeneratorTestUnit newTestUnit(ExtensionModelLoader loader, Class<?> extensionClass, String fileName) {
            return new SchemaGeneratorTestUnit(loader, extensionClass, fileName);
        }

        ExtensionModelLoader getLoader() {
            return this.loader;
        }

        Class<?> getExtensionClass() {
            return this.extensionClass;
        }

        String getFileName() {
            return this.fileName;
        }
    }

    private static class SchemaTestDslContext
    implements DslResolvingContext {
        private SchemaTestDslContext() {
        }

        public Optional<ExtensionModel> getExtension(String name) {
            return Optional.ofNullable(extensionModels.get(name));
        }

        public Optional<ExtensionModel> getExtensionForType(String typeId) {
            return this.getTypeCatalog().getDeclaringExtension(typeId).flatMap(this::getExtension);
        }

        public Set<ExtensionModel> getExtensions() {
            return ImmutableSet.copyOf(extensionModels.values());
        }

        public TypeCatalog getTypeCatalog() {
            return TypeCatalog.getDefault((Set)ImmutableSet.copyOf(extensionModels.values()));
        }
    }
}

