/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.description;

import com.google.common.truth.SubjectFactory;
import com.google.common.truth.Truth;
import com.google.testing.compile.JavaFileObjects;
import com.google.testing.compile.JavaSourcesSubject;
import com.google.testing.compile.JavaSourcesSubjectFactory;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNull;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.DescribedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.resources.GeneratedResource;
import org.mule.runtime.extension.internal.loader.DefaultExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.ExtensionModelFactory;
import org.mule.runtime.module.extension.internal.AbstractAnnotationProcessorTestCase;
import org.mule.runtime.module.extension.internal.capability.xml.description.ExtensionDescriptionDocumenter;
import org.mule.runtime.module.extension.internal.capability.xml.extension.multiple.config.TestExtensionWithDocumentationAndMultipleConfig;
import org.mule.runtime.module.extension.internal.capability.xml.extension.single.config.TestExtensionWithDocumentationAndSingleConfig;
import org.mule.runtime.module.extension.internal.loader.enricher.ExtensionDescriptionsEnricher;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.resources.documentation.ExtensionDocumentationResourceGenerator;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=Parameterized.class)
public class ExtensionDescriptionDocumenterTestCase
extends AbstractAnnotationProcessorTestCase {
    private static final String MULTIPLE_CONFIGS = "multipleConfigs";
    private static final String SINGLE_CONFIG = "singleConfig";
    private final String name;
    private final Class<?> extensionClass;
    private final String expectedProductPath;
    private final String sourcePath;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({MULTIPLE_CONFIGS, TestExtensionWithDocumentationAndMultipleConfig.class, "/META-INF/multiple-extension-descriptions.xml", "src/test/java/org/mule/runtime/module/extension/internal/capability/xml/extension/multiple/config"}, {SINGLE_CONFIG, TestExtensionWithDocumentationAndSingleConfig.class, "/META-INF/single-extension-descriptions.xml", "src/test/java/org/mule/runtime/module/extension/internal/capability/xml/extension/single/config"});
    }

    public ExtensionDescriptionDocumenterTestCase(String name, Class<?> extension, String expectedProductPath, String sourcePath) {
        this.name = name;
        this.extensionClass = extension;
        this.expectedProductPath = expectedProductPath;
        this.sourcePath = sourcePath;
    }

    @Test
    public void persistDocumentation() throws Exception {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(this.expectedProductPath);
        MatcherAssert.assertThat((Object)in, (Matcher)Matchers.is((Matcher)IsNull.notNullValue()));
        String expectedXml = IOUtils.toString((InputStream)in);
        TestProcessor processor = new TestProcessor(this.extensionClass);
        this.doCompile(processor);
        ExtensionDocumentationResourceGenerator generator = new ExtensionDocumentationResourceGenerator();
        GeneratedResource resource = (GeneratedResource)generator.generateResource(processor.getExtensionModel()).orElseThrow(() -> new RuntimeException("No Documentation Generated"));
        ExtensionsTestUtils.compareXML((String)expectedXml, (String)new String(resource.getContent()));
    }

    @Test
    public void loadDocumentationFromFile() throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        DefaultExtensionLoadingContext ctx = new DefaultExtensionLoadingContext(cl, DslResolvingContext.getDefault(Collections.emptySet()));
        DefaultJavaModelLoaderDelegate loader = new DefaultJavaModelLoaderDelegate(this.extensionClass, "1.0.0-dev");
        loader.declare((ExtensionLoadingContext)ctx);
        ExtensionDescriptionsEnricher enricher = new ExtensionDescriptionsEnricher();
        enricher.enrich((ExtensionLoadingContext)ctx);
        ExtensionModelFactory factory = new ExtensionModelFactory();
        ExtensionModel extensionModel = factory.create((ExtensionLoadingContext)ctx);
        this.assertDescribedExtensionModel(extensionModel);
    }

    @Test
    public void describeDescriptions() throws Exception {
        TestProcessor processor = new TestProcessor(this.extensionClass);
        this.doCompile(processor);
        this.assertDescribedExtensionModel(processor.getExtensionModel());
    }

    private void assertDescribedExtensionModel(ExtensionModel extensionModel) {
        if (this.isSingleConfigTest()) {
            this.assertDescriptionsSingleConfig(extensionModel);
        } else {
            this.assertDescriptionsMultipleConfigs(extensionModel);
        }
    }

    private void assertDescriptionsMultipleConfigs(ExtensionModel declaration) {
        List configurations = declaration.getConfigurationModels();
        this.assertDescription((DescribedObject)declaration, "Test Extension Description");
        MatcherAssert.assertThat((Object)configurations, (Matcher)Matchers.hasSize((int)2));
        ConfigurationModel first = (ConfigurationModel)configurations.get(1);
        this.assertDescription((DescribedObject)first, "This is some Config documentation.");
        this.assertDescription((DescribedObject)first.getConnectionProviders().get(0), "Another Provider Documentation");
        this.assertDescription((DescribedObject)first.getConnectionProviders().get(1), "Provider Documentation");
        ConfigurationModel second = (ConfigurationModel)configurations.get(0);
        this.assertDescription((DescribedObject)second, "This is some Another Config documentation.");
        this.assertDescription((DescribedObject)second.getConnectionProviders().get(0), "Another Provider Documentation");
        List params = first.getAllParameterModels();
        this.assertDescription((DescribedObject)params.get(0), "Config parameter");
        this.assertDescription((DescribedObject)params.get(1), "Config Parameter with an Optional value");
        this.assertDescription((DescribedObject)params.get(2), "Configures the minimum amount of time that a dynamic configuration instance can remain idle before the runtime considers it eligible for expiration. This does not mean that the platform will expire the instance at the exact moment that it becomes eligible. The runtime will actually purge the instances when it sees it fit.");
        this.assertDescription((DescribedObject)params.get(3), "Group parameter 1");
        this.assertDescription((DescribedObject)params.get(4), "Group parameter 2");
        List operations = declaration.getOperationModels();
        OperationModel operation = this.getOperationByName(operations, "operation");
        this.assertDescription((DescribedObject)operation, "Test Operation");
        this.assertDescription((DescribedObject)operation.getAllParameterModels().get(0), "test value");
        OperationModel inheritedOperation = this.getOperationByName(operations, "inheritedOperation");
        this.assertDescription((DescribedObject)inheritedOperation, "Inherited Operation Documentation");
        this.assertDescription((DescribedObject)inheritedOperation.getAllParameterModels().get(0), "parameter documentation for an inherited operation.");
        OperationModel greetFriend = this.getOperationByName(operations, "greetFriend");
        this.assertDescription((DescribedObject)greetFriend, "This method greets a friend");
        this.assertDescription((DescribedObject)greetFriend.getAllParameterModels().get(0), "This is one of my friends");
        this.assertDescription((DescribedObject)greetFriend.getAllParameterModels().get(1), "Some other friend");
        List connectedOperations = first.getOperationModels();
        OperationModel connectedOpe = (OperationModel)connectedOperations.get(0);
        this.assertDescription((DescribedObject)connectedOpe, "Test Operation with blank parameter description");
        this.assertDescription((DescribedObject)connectedOpe.getAllParameterModels().get(0), "");
    }

    private void assertDescriptionsSingleConfig(ExtensionModel extensionModel) {
        MatcherAssert.assertThat((Object)extensionModel.getConfigurationModels(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)extensionModel.getOperationModels(), (Matcher)Matchers.hasSize((int)1));
        OperationModel withParameterGroup = (OperationModel)extensionModel.getOperationModels().get(0);
        this.assertDescription((DescribedObject)withParameterGroup, "Operation with parameter group");
        List operationParams = withParameterGroup.getAllParameterModels();
        this.assertDescription((DescribedObject)operationParams.get(0), "value param description");
        this.assertDescription((DescribedObject)operationParams.get(1), "First Description");
        this.assertDescription((DescribedObject)operationParams.get(2), "Second Description");
        ConfigurationModel config = (ConfigurationModel)extensionModel.getConfigurationModels().get(0);
        this.assertDescription((DescribedObject)extensionModel, "Test Extension Description with single config");
        this.assertDescription((DescribedObject)config, "Default configuration");
        this.assertDescription((DescribedObject)config.getAllParameterModels().get(0), "Config parameter");
        this.assertDescription((DescribedObject)config.getAllParameterModels().get(1), "Config Parameter with an Optional value");
        MatcherAssert.assertThat((Object)config.getOperationModels(), (Matcher)Matchers.hasSize((int)1));
        this.assertDescription((DescribedObject)config.getOperationModels().get(0), "Operation with description");
        ConnectionProviderModel provider = (ConnectionProviderModel)config.getConnectionProviders().get(0);
        this.assertDescription((DescribedObject)provider, "Provider description");
        this.assertDescription((DescribedObject)provider.getAllParameterModels().get(0), "Connection Param Description");
        this.assertDescription((DescribedObject)provider.getAllParameterModels().get(1), "First Description");
        this.assertDescription((DescribedObject)provider.getAllParameterModels().get(2), "Second Description");
    }

    private void doCompile(TestProcessor processor) throws Exception {
        ((JavaSourcesSubject)Truth.assert_().about((SubjectFactory)JavaSourcesSubjectFactory.javaSources()).that(this.testSourceFiles())).withCompilerOptions(new String[]{"-Aextension.version=1.0.0-dev"}).processedWith((Processor)processor, new Processor[0]).compilesWithoutError();
    }

    private void assertDescription(DescribedObject object, String desc) {
        MatcherAssert.assertThat((Object)object.getDescription(), (Matcher)Matchers.is((Object)desc));
    }

    private OperationModel getOperationByName(List<OperationModel> ops, String opeName) {
        return ops.stream().filter(operationModel -> operationModel.getName().equals(opeName)).findAny().orElse(null);
    }

    private boolean isSingleConfigTest() {
        return SINGLE_CONFIG.equals(this.name);
    }

    protected Iterable<JavaFileObject> testSourceFiles() throws Exception {
        File folder = new File(((Object)((Object)this)).getClass().getClassLoader().getResource("").getPath().toString());
        folder = folder.getParentFile().getParentFile();
        folder = new File(folder, this.sourcePath);
        File[] files = folder.listFiles((dir, name) -> name.endsWith(".java"));
        MatcherAssert.assertThat((Object)files, (Matcher)Matchers.is((Matcher)IsNull.notNullValue()));
        ArrayList<JavaFileObject> javaFileObjects = new ArrayList<JavaFileObject>(files.length);
        for (File file : files) {
            javaFileObjects.add(JavaFileObjects.forResource((URL)file.toURI().toURL()));
        }
        return javaFileObjects;
    }

    @SupportedAnnotationTypes(value={"org.mule.runtime.extension.api.annotation.Extension"})
    @SupportedSourceVersion(value=SourceVersion.RELEASE_8)
    @SupportedOptions(value={"extension.version"})
    private class TestProcessor
    extends AbstractProcessor {
        private final Class<?> extensionClass;
        private ExtensionDeclaration declaration;
        private DefaultExtensionLoadingContext ctx;

        public TestProcessor(Class<?> extensionClass) {
            this.extensionClass = extensionClass;
        }

        @Override
        public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
            if (this.declaration == null) {
                ExtensionDescriptionDocumenter documenter = new ExtensionDescriptionDocumenter(this.processingEnv, roundEnv);
                Element extension = roundEnv.getElementsAnnotatedWith(Extension.class).stream().filter(element -> element.getSimpleName().contentEquals(this.extensionClass.getSimpleName())).findFirst().get();
                MatcherAssert.assertThat((Object)extension, (Matcher)Matchers.instanceOf(TypeElement.class));
                this.ctx = new DefaultExtensionLoadingContext(Thread.currentThread().getContextClassLoader(), DslResolvingContext.getDefault(Collections.emptySet()));
                DefaultJavaModelLoaderDelegate loader = new DefaultJavaModelLoaderDelegate(this.extensionClass, "1.0.0-dev");
                this.declaration = (ExtensionDeclaration)loader.declare((ExtensionLoadingContext)this.ctx).getDeclaration();
                documenter.document(this.declaration, (TypeElement)extension);
            }
            return false;
        }

        ExtensionModel getExtensionModel() {
            ExtensionModelFactory factory = new ExtensionModelFactory();
            return factory.create((ExtensionLoadingContext)this.ctx);
        }
    }
}

