/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.resources;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.extension.api.persistence.ExtensionModelJsonSerializer;
import org.mule.runtime.module.extension.api.loader.java.DefaultJavaExtensionModelLoader;
import org.mule.runtime.module.extension.internal.loader.enricher.JavaXmlDeclarationEnricher;
import org.mule.runtime.module.extension.soap.api.loader.SoapExtensionModelLoader;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.function.extension.WeaveFunctionExtension;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.marvel.MarvelExtension;
import org.mule.test.metadata.extension.MetadataExtension;
import org.mule.test.oauth.TestOAuthExtension;
import org.mule.test.petstore.extension.PetStoreConnector;
import org.mule.test.ram.RickAndMortyExtension;
import org.mule.test.substitutiongroup.extension.SubstitutionGroupExtension;
import org.mule.test.subtypes.extension.SubTypesMappingConnector;
import org.mule.test.transactional.TransactionalExtension;
import org.mule.test.typed.value.extension.extension.TypedValueExtension;
import org.mule.test.values.extension.ValuesExtension;
import org.mule.test.vegan.extension.VeganExtension;
import org.skyscreamer.jsonassert.JSONAssert;

@SmallTest
@RunWith(value=Parameterized.class)
public class ExtensionModelJsonGeneratorTestCase
extends AbstractMuleTestCase {
    static final Map<String, ExtensionModel> extensionModels = new HashMap<String, ExtensionModel>();
    private static ExtensionModelLoader javaLoader = new DefaultJavaExtensionModelLoader();
    private static ExtensionModelLoader soapLoader = new SoapExtensionModelLoader();
    @Parameterized.Parameter(value=0)
    public ExtensionModel extensionUnderTest;
    @Parameterized.Parameter(value=1)
    public String expectedSource;
    private ExtensionModelJsonSerializer generator;
    private String expectedJson;

    @Parameterized.Parameters(name="{1}")
    public static Collection<Object[]> data() {
        ClassLoader classLoader = ExtensionModelJsonGeneratorTestCase.class.getClassLoader();
        ServiceRegistry serviceRegistry = (ServiceRegistry)Mockito.mock(ServiceRegistry.class);
        Mockito.when((Object)serviceRegistry.lookupProviders(DeclarationEnricher.class, classLoader)).thenReturn(Arrays.asList(new JavaXmlDeclarationEnricher()));
        List<ExtensionJsonGeneratorTestUnit> extensions = Arrays.asList(ExtensionJsonGeneratorTestUnit.newTestUnit(javaLoader, VeganExtension.class, "vegan.json"), ExtensionJsonGeneratorTestUnit.newTestUnit(javaLoader, PetStoreConnector.class, "petstore.json"), ExtensionJsonGeneratorTestUnit.newTestUnit(javaLoader, MetadataExtension.class, "metadata.json"), ExtensionJsonGeneratorTestUnit.newTestUnit(javaLoader, HeisenbergExtension.class, "heisenberg.json"), ExtensionJsonGeneratorTestUnit.newTestUnit(javaLoader, SubstitutionGroupExtension.class, "substitutiongroup.json"), ExtensionJsonGeneratorTestUnit.newTestUnit(javaLoader, TransactionalExtension.class, "tx-ext.json"), ExtensionJsonGeneratorTestUnit.newTestUnit(javaLoader, SubTypesMappingConnector.class, "subtypes.json"), ExtensionJsonGeneratorTestUnit.newTestUnit(javaLoader, MarvelExtension.class, "marvel.json"), ExtensionJsonGeneratorTestUnit.newTestUnit(soapLoader, RickAndMortyExtension.class, "ram.json"), ExtensionJsonGeneratorTestUnit.newTestUnit(javaLoader, TypedValueExtension.class, "typed-value.json"), ExtensionJsonGeneratorTestUnit.newTestUnit(javaLoader, TestOAuthExtension.class, "test-oauth.json"), ExtensionJsonGeneratorTestUnit.newTestUnit(javaLoader, WeaveFunctionExtension.class, "test-fn.json"), ExtensionJsonGeneratorTestUnit.newTestUnit(javaLoader, ValuesExtension.class, "values.json"));
        BiFunction<Class, ExtensionModelLoader, ExtensionModel> createExtensionModel = (extension, loader) -> {
            ExtensionModel model = ExtensionModelJsonGeneratorTestCase.loadExtension(extension, loader);
            if (extensionModels.put(model.getName(), model) != null) {
                throw new IllegalArgumentException(String.format("Extension names must be unique. Name [%s] for extension [%s] was already used", model.getName(), extension.getName()));
            }
            return model;
        };
        return extensions.stream().map(e -> new Object[]{createExtensionModel.apply(e.getExtensionClass(), e.getLoader()), e.getFileName()}).collect(Collectors.toList());
    }

    private boolean shouldUpdateExpectedFilesOnError() {
        return false;
    }

    @Before
    public void setup() throws IOException {
        this.generator = new ExtensionModelJsonSerializer(true);
        this.expectedJson = IOUtils.getResourceAsString((String)("models/" + this.expectedSource), ((Object)((Object)this)).getClass()).trim();
    }

    @Test
    public void generate() throws Exception {
        String json = this.generator.serialize(this.extensionUnderTest).trim();
        try {
            JSONAssert.assertEquals((String)this.expectedJson, (String)json, (boolean)true);
        }
        catch (AssertionError e) {
            if (this.shouldUpdateExpectedFilesOnError()) {
                this.updateExpectedJson(json);
            }
            System.out.println("Expected: \n " + this.expectedJson);
            System.out.println("\n\nBut Got: \n " + json);
            throw e;
        }
    }

    @Test
    public void load() throws Exception {
        ExtensionModel result = this.generator.deserialize(this.expectedJson);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)this.extensionUnderTest));
    }

    private void updateExpectedJson(String json) throws URISyntaxException, IOException {
        File root = new File(IOUtils.getResourceAsUrl((String)("models/" + this.expectedSource), ((Object)((Object)this)).getClass()).toURI()).getParentFile().getParentFile().getParentFile().getParentFile();
        File testDir = new File(root, "src/test/resources/models");
        File target = new File(testDir, this.expectedSource);
        FileUtils.stringToFile((String)target.getAbsolutePath(), (String)json);
        System.out.println(this.expectedSource + " fixed");
    }

    public static ExtensionModel loadExtension(Class<?> clazz, ExtensionModelLoader loader) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", clazz.getName());
        params.put("version", "4.0.0-SNAPSHOT");
        DslResolvingContext dslResolvingContext = DslResolvingContext.getDefault(Collections.emptySet());
        return loader.loadExtensionModel(clazz.getClassLoader(), dslResolvingContext, params);
    }

    static class ExtensionJsonGeneratorTestUnit {
        final ExtensionModelLoader loader;
        final Class<?> extensionClass;
        final String fileName;

        private ExtensionJsonGeneratorTestUnit(ExtensionModelLoader loader, Class<?> extensionClass, String fileName) {
            this.loader = loader;
            this.extensionClass = extensionClass;
            this.fileName = fileName;
        }

        static ExtensionJsonGeneratorTestUnit newTestUnit(ExtensionModelLoader modelLoader, Class<?> extensionClass, String fileName) {
            return new ExtensionJsonGeneratorTestUnit(modelLoader, extensionClass, fileName);
        }

        ExtensionModelLoader getLoader() {
            return this.loader;
        }

        Class<?> getExtensionClass() {
            return this.extensionClass;
        }

        String getFileName() {
            return this.fileName;
        }
    }
}

