/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class DynamicConfigExpirationTestCase
extends AbstractExtensionFunctionalTestCase {
    protected String getConfigFile() {
        return "dynamic-config-expiration.xml";
    }

    @Test
    public void expireDynamicConfig() throws Exception {
        HeisenbergExtension config = this.invokeDynamicConfig("dynamic", "heisenberg", "Walt");
        this.assertExpired(config, 5000L, 1000L);
        this.assertInitialised(config);
    }

    @Test
    public void expireDynamicConfigWithCustomExpiration() throws Exception {
        HeisenbergExtension config = this.invokeDynamicConfig("dynamicWithCustomExpiration", "heisenbergWithCustomExpiration", "Walter Jr.");
        try {
            this.assertExpired(config, 1500L, 100L);
            Assert.fail((String)"Config should not have been expired");
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        this.assertExpired(config, 5000L, 1000L);
        this.assertInitialised(config);
    }

    private void assertInitialised(HeisenbergExtension config) {
        Assert.assertThat((Object)config.getInitialise(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)config.getStart(), (Matcher)CoreMatchers.is((Object)1));
    }

    private void assertExpired(HeisenbergExtension config, long timeoutMilis, long pollDelayMillis) {
        PollingProber prober = new PollingProber(timeoutMilis, pollDelayMillis);
        prober.check((Probe)new JUnitLambdaProbe(() -> {
            Assert.assertThat((Object)config.getStop(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)config.getDispose(), (Matcher)CoreMatchers.is((Object)1));
            return true;
        }, "config was not stopped or disposed"));
    }

    private HeisenbergExtension invokeDynamicConfig(String flowName, String configName, String payload) throws Exception {
        FlowRunner runner = (FlowRunner)this.flowRunner(flowName).withPayload((Object)payload);
        CoreEvent event = runner.buildEvent();
        String returnedName = this.getPayloadAsString(runner.run().getMessage());
        HeisenbergExtension config = (HeisenbergExtension)muleContext.getExtensionManager().getConfiguration(configName, event).getValue();
        Assert.assertThat((Object)returnedName, (Matcher)CoreMatchers.is((Object)payload));
        Assert.assertThat((Object)config.getPersonalInfo().getName(), (Matcher)CoreMatchers.is((Object)payload));
        return config;
    }
}

