/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension;

import javax.inject.Inject;
import javax.inject.Named;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.tck.MuleTestUtils;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

public class ExtensionAsInjectedDependenciesTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final String STATIC_HEISENBERG = "staticHeisenberg";
    private static final String DYNAMIC_AGE_HEISENBERG = "dynamicAgeHeisenberg";
    private Dependent dependent;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.dependent = (Dependent)muleContext.getInjector().inject((Object)new Dependent());
    }

    protected String getConfigFile() {
        return "heisenberg-injected.xml";
    }

    @Test
    public void staticHeisenbergWasInjected() throws Exception {
        this.assertCorrectProviderInjected(STATIC_HEISENBERG, this.dependent.getStaticHeisenberg());
        HeisenbergExtension heisenberg = (HeisenbergExtension)ExtensionsTestUtils.getConfigurationFromRegistry((String)STATIC_HEISENBERG, (CoreEvent)this.testEvent(), (MuleContext)muleContext);
        Assert.assertThat((Object)heisenberg.getPersonalInfo().getAge(), (Matcher)CoreMatchers.is((Object)50));
    }

    @Test
    public void dynamicHeisenbergWasInjected() throws Exception {
        this.assertCorrectProviderInjected(DYNAMIC_AGE_HEISENBERG, this.dependent.getDynamicAgeHeisenberg());
        int age = 52;
        CoreEvent event = CoreEvent.builder((EventContext)EventContextFactory.create((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)"")).addVariable("age", (Object)52).build();
        HeisenbergExtension heisenberg = (HeisenbergExtension)ExtensionsTestUtils.getConfigurationFromRegistry((String)DYNAMIC_AGE_HEISENBERG, (CoreEvent)event, (MuleContext)muleContext);
        Assert.assertThat((Object)heisenberg.getPersonalInfo().getAge(), (Matcher)CoreMatchers.is((Object)52));
    }

    private void assertCorrectProviderInjected(String key, ConfigurationProvider expected) {
        Assert.assertThat((Object)expected, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance(this.registry.lookupByName(key).get())));
    }

    public static class Dependent {
        @Inject
        @Named(value="staticHeisenberg")
        private ConfigurationProvider staticHeisenberg;
        @Inject
        @Named(value="dynamicAgeHeisenberg")
        private ConfigurationProvider dynamicAgeHeisenberg;

        public ConfigurationProvider getStaticHeisenberg() {
            return this.staticHeisenberg;
        }

        public ConfigurationProvider getDynamicAgeHeisenberg() {
            return this.dynamicAgeHeisenberg;
        }
    }
}

