/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.api.streaming.bytes.InMemoryCursorStreamConfig;
import org.mule.runtime.core.api.streaming.bytes.InMemoryCursorStreamProvider;
import org.mule.tck.core.streaming.SimpleByteBufferManager;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.w3c.dom.NodeList;

public class FunctionExecutionTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final String FUNCTIONS_CONFIG_XML = "functions-config.xml";
    private ExtendedExpressionManager expressionManager;

    protected String[] getConfigFiles() {
        return new String[]{FUNCTIONS_CONFIG_XML};
    }

    protected boolean isDisposeContextPerClass() {
        return true;
    }

    @Before
    public void setupManager() {
        this.expressionManager = muleContext.getExpressionManager();
    }

    @Test
    public void echoFromManager() throws Exception {
        TypedValue result = this.expressionManager.evaluate("Fn::defaultPrimitives()");
        Assert.assertThat((Object)result.getValue(), (Matcher)Matchers.is((Object)"SUCCESS"));
    }

    @Test
    public void echoWithDefault() throws Exception {
        Object value = ((FlowRunner)this.flowRunner("echoWithDefault").withPayload((Object)"sampleData")).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)Matchers.is((Object)"prefix_sampleData"));
    }

    @Test
    public void variableGlobalEcho() throws Exception {
        Object value = ((FlowRunner)this.flowRunner("variableGlobalEcho").withVariable("myMessage", (Object)"sampleData")).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)Matchers.is((Object)"sampleData"));
    }

    @Test
    public void toMap() throws Exception {
        Map value = (Map)this.flowRunner("toMap").run().getMessage().getPayload().getValue();
        Assert.assertThat(value.get("user"), (Matcher)Matchers.is((Object)"pepe"));
    }

    @Test
    public void xpathWithDefaults() throws Exception {
        Object value = ((FlowRunner)this.flowRunner("xpathWithDefaults").withPayload((Object)this.getDocumentStream())).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)Matchers.is((Object)"xpathWithDefaults"));
    }

    @Test
    public void xpathWithDefaultNode() throws Exception {
        InputStream stream = this.getDocumentStream();
        InMemoryCursorStreamProvider streamProvider = new InMemoryCursorStreamProvider(stream, InMemoryCursorStreamConfig.getDefault(), (ByteBufferManager)new SimpleByteBufferManager());
        Object value = ((FlowRunner)this.flowRunner("xpathWithDefaultNode").withVariable("xmlPayload", (Object)streamProvider)).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)Matchers.is((Object)"xpathWithDefaultNode"));
    }

    @Test
    public void xpathWithOverrides() throws Exception {
        Object value = ((FlowRunner)this.flowRunner("xpathWithOverrides").withVariable("xmlPayload", (Object)this.getDocumentStream())).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)Matchers.instanceOf(NodeList.class));
        Assert.assertThat((Object)((NodeList)value).getLength(), (Matcher)Matchers.is((Object)7));
    }

    @Test
    public void executeAliasedFunctionName() throws Exception {
        TypedValue result = this.expressionManager.evaluate("Fn::partition([1,2,3,4,5,6,7,8], 3)");
        List value = (List)result.getValue();
        Assert.assertThat((Object)value, (Matcher)IsCollectionWithSize.hasSize((int)3));
        Assert.assertThat(value.get(0), (Matcher)IsCollectionWithSize.hasSize((int)3));
        Assert.assertThat(value.get(1), (Matcher)IsCollectionWithSize.hasSize((int)3));
        Assert.assertThat(value.get(2), (Matcher)IsCollectionWithSize.hasSize((int)2));
    }

    private InputStream getDocumentStream() {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(FUNCTIONS_CONFIG_XML);
    }
}

