/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension;

import java.math.BigDecimal;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.tck.MuleTestUtils;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

public class StatefulOperationTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final String TENANT_1 = "heisenberg";
    private static final String TENANT_2 = "walter";
    private static final String STATIC_CONFIG = "staticHeisenberg";
    private static final String DYNAMIC_CONFIG = "heisenberg";

    protected String getConfigFile() {
        return "heisenberg-stateful-operation-config.xml";
    }

    @Test
    public void stateOnOperationInstance() throws Exception {
        Assert.assertThat((Object)this.dynamicLaunder(), (Matcher)CoreMatchers.is((Object)40000L));
    }

    @Test
    public void stateOnDynamicConfigs() throws Exception {
        this.dynamicLaunder();
        this.assertRemainingMoney("heisenberg", "heisenberg", 70000L);
        this.assertRemainingMoney("heisenberg", TENANT_2, 90000L);
    }

    @Test
    public void stateOnStaticConfig() throws Exception {
        this.staticLounder(10000L);
        this.staticLounder(5000L);
        this.assertRemainingMoney(STATIC_CONFIG, "", 85000L);
    }

    private long dynamicLaunder() throws Exception {
        this.doDynamicLaunder("heisenberg", 30000L);
        return this.doDynamicLaunder(TENANT_2, 10000L);
    }

    private void assertRemainingMoney(String configName, String name, long expectedAmount) throws Exception {
        CoreEvent event = CoreEvent.builder((EventContext)EventContextFactory.create((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), (ComponentLocation)TEST_CONNECTOR_LOCATION)).message(Message.of((Object)"")).addVariable("myName", (Object)name).build();
        HeisenbergExtension heisenbergExtension = (HeisenbergExtension)ExtensionsTestUtils.getConfigurationFromRegistry((String)configName, (CoreEvent)event, (MuleContext)muleContext);
        Assert.assertThat((Object)heisenbergExtension.getMoney(), (Matcher)CoreMatchers.equalTo((Object)BigDecimal.valueOf(expectedAmount)));
    }

    private long doDynamicLaunder(String name, long amount) throws Exception {
        return (Long)((FlowRunner)((FlowRunner)this.flowRunner("laundry").withPayload((Object)amount)).withVariable("myName", (Object)name)).run().getMessage().getPayload().getValue();
    }

    private long staticLounder(long amount) throws Exception {
        return (Long)((FlowRunner)this.flowRunner("staticLaundry").withPayload((Object)amount)).run().getMessage().getPayload().getValue();
    }
}

