/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.connector;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.petstore.extension.PetStoreConnector;

public class PetStoreDefaultEncodingTestCase
extends AbstractExtensionFunctionalTestCase {
    private String defaultEncoding;
    private static Reference<Message> messageHolder = new Reference();

    protected String getConfigFile() {
        return "petstore-default-mule-encoding.xml";
    }

    @Before
    public void setUp() {
        messageHolder.set(null);
        this.defaultEncoding = muleContext.getConfiguration().getDefaultEncoding();
        MatcherAssert.assertThat((Object)this.defaultEncoding, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @After
    public void tearDown() {
        messageHolder.set(null);
    }

    @Test
    public void configEncoding() throws Exception {
        PetStoreConnector config = (PetStoreConnector)this.flowRunner("configEncoding").run().getMessage().getPayload().getValue();
        this.assertDefaultEncoding(config.getEncoding());
    }

    @Test
    public void topLevelEncoding() throws Exception {
        this.assertDefaultEncoding((String)this.flowRunner("topLevelEncoding").run().getMessage().getPayload().getValue());
    }

    @Test
    public void inlinePojoEncoding() throws Exception {
        this.assertDefaultEncoding((String)this.flowRunner("inlinePojoEncoding").run().getMessage().getPayload().getValue());
    }

    @Test
    public void argumentEncoding() throws Exception {
        this.assertDefaultEncoding((String)this.flowRunner("argumentEncoding").run().getMessage().getPayload().getValue());
    }

    @Test
    public void sourceEncoding() throws Exception {
        this.startFlow("sourceEncoding");
        this.assertDefaultEncoding((String)this.listen().getPayload().getValue());
    }

    private void assertDefaultEncoding(String encoding) {
        MatcherAssert.assertThat((Object)encoding, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)encoding, (Matcher)Matchers.is((Object)this.defaultEncoding));
    }

    private Message listen() {
        PollingProber prober = new PollingProber(1000L, 50L);
        prober.check((Probe)new JUnitLambdaProbe(() -> messageHolder.get() != null));
        return (Message)messageHolder.get();
    }

    private void startFlow(String flowName) throws Exception {
        ((Flow)this.getFlowConstruct(flowName)).start();
    }

    public static class TestProcessor
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            messageHolder.set((Object)event.getMessage());
            return event;
        }
    }
}

