/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.metadata;

import java.io.IOException;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assume;
import org.junit.Test;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataComponent;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.module.extension.api.metadata.MultilevelMetadataKeyBuilder;
import org.mule.test.module.extension.metadata.AbstractMetadataOperationTestCase;
import org.mule.test.module.extension.metadata.MetadataExtensionFunctionalTestCase;

public class MetadataNegativeTestCase
extends AbstractMetadataOperationTestCase {
    private static final String NOT_A_METADATA_PROVIDER = "is not a MetadataProvider or MetadataEntityProvider";
    private static final String NO_OBJECT_FOUND = "No object found at location %s";
    private static final String FAIL_WITH_RESOLVING_EXCEPTION = "failWithResolvingException";
    private static final String FAIL_WITH_RUNTIME_EXCEPTION = "failWithRuntimeException";
    private static final String NON_EXISTING_FLOW = "nonExistingFlow";
    private static final String NON_EXISTING_CONFIG = "nonexisting-config";
    private static final String LOGGER_FLOW = "loggerFlow";
    private static final String FLOW_WITHOUT_SOURCE = "flowWithoutSource";
    private static final String CONFIGURATION_CANNOT_BE_DYNAMIC = "Configuration used for Metadata fetch cannot be dynamic";
    private static final String NO_DYNAMIC_KEY_AVAILABLE = "Component [%s] is not a MetadataKeyProvider";
    private static final String DYNAMIC_CONFIG = "dynamic-config";
    private static final String NO_SUCH_COMPONENT_MODEL_EXCEPTION_CLASS_NAME = "org.mule.runtime.config.internal.dsl.model.NoSuchComponentModelException";
    private static final String INVALID_COMPONENT_EXCEPTION_CLASSNAME = "org.mule.runtime.core.internal.metadata.InvalidComponentIdException";

    public MetadataNegativeTestCase(MetadataExtensionFunctionalTestCase.ResolutionType resolutionType) {
        super(resolutionType);
    }

    protected String getConfigFile() {
        return "metadata-tests.xml";
    }

    @Test
    public void getOperationMetadataWithResolvingException() throws Exception {
        this.location = Location.builder().globalName(FAIL_WITH_RESOLVING_EXCEPTION).addProcessorsPart().addIndexPart(0).build();
        MetadataResult metadata = this.getComponentDynamicMetadata(PERSON_METADATA_KEY);
        MatcherAssert.assertThat((Object)metadata.isSuccess(), (Matcher)CoreMatchers.is((Object)false));
        this.assertFailureResult(metadata, 2);
        List failures = metadata.getFailures();
        this.assertMetadataFailure((MetadataFailure)failures.get(0), "", FailureCode.CONNECTION_FAILURE, "", MetadataComponent.OUTPUT_ATTRIBUTES, "");
        this.assertMetadataFailure((MetadataFailure)failures.get(1), "", FailureCode.CONNECTION_FAILURE, "", MetadataComponent.INPUT, "content");
    }

    @Test
    public void getKeysWithRuntimeException() throws Exception {
        this.location = Location.builder().globalName(FAIL_WITH_RUNTIME_EXCEPTION).addProcessorsPart().addIndexPart(0).build();
        MetadataResult metadata = this.metadataService.getMetadataKeys(this.location);
        this.assertFailureResult(metadata, 1);
        this.assertMetadataFailure((MetadataFailure)metadata.getFailures().get(0), "", FailureCode.UNKNOWN, RuntimeException.class.getName(), MetadataComponent.KEYS);
    }

    @Test
    public void getOperationMetadataWithRuntimeException() throws Exception {
        this.location = Location.builder().globalName(FAIL_WITH_RUNTIME_EXCEPTION).addProcessorsPart().addIndexPart(0).build();
        MetadataResult metadata = this.getComponentDynamicMetadata(PERSON_METADATA_KEY);
        this.assertFailureResult(metadata, 2);
        this.assertMetadataFailure((MetadataFailure)metadata.getFailures().get(0), "", FailureCode.UNKNOWN, "", MetadataComponent.OUTPUT_ATTRIBUTES);
        this.assertMetadataFailure((MetadataFailure)metadata.getFailures().get(1), "", FailureCode.UNKNOWN, "", MetadataComponent.INPUT, "content");
    }

    @Test
    public void flowDoesNotExist() throws Exception {
        this.location = Location.builder().globalName(NON_EXISTING_FLOW).addProcessorsPart().addIndexPart(0).build();
        MetadataResult result = this.getComponentDynamicMetadata(PERSON_METADATA_KEY);
        this.assertFailureResult(result, 1);
        this.assertMetadataFailure((MetadataFailure)result.getFailures().get(0), String.format(NO_OBJECT_FOUND, this.location.toString()), FailureCode.COMPONENT_NOT_FOUND, NO_SUCH_COMPONENT_MODEL_EXCEPTION_CLASS_NAME, MetadataComponent.COMPONENT, "");
    }

    @Test
    public void processorDoesNotExist() throws Exception {
        String notValidIndex = "10";
        this.location = Location.builder().globalName("contentAndOutputMetadataWithKeyId").addProcessorsPart().addIndexPart(Integer.valueOf(notValidIndex).intValue()).build();
        MetadataResult result = this.getComponentDynamicMetadata(PERSON_METADATA_KEY);
        this.assertFailureResult(result, 1);
        this.assertMetadataFailure((MetadataFailure)result.getFailures().get(0), String.format(NO_OBJECT_FOUND, this.location), FailureCode.COMPONENT_NOT_FOUND, NO_SUCH_COMPONENT_MODEL_EXCEPTION_CLASS_NAME, MetadataComponent.COMPONENT);
    }

    @Test
    public void failToGetMetadataFromNonExistingSource() throws IOException {
        this.location = Location.builder().globalName(FLOW_WITHOUT_SOURCE).addSourcePart().build();
        MetadataResult result = this.metadataService.getMetadataKeys(this.location);
        this.assertFailureResult(result, 1);
        this.assertMetadataFailure((MetadataFailure)result.getFailures().get(0), String.format(NO_OBJECT_FOUND, this.location), FailureCode.COMPONENT_NOT_FOUND, NO_SUCH_COMPONENT_MODEL_EXCEPTION_CLASS_NAME, MetadataComponent.COMPONENT);
    }

    @Test
    public void processorIsNotEntityMetadataProvider() throws Exception {
        this.location = Location.builder().globalName(LOGGER_FLOW).addProcessorsPart().addIndexPart(0).build();
        MetadataResult result = this.metadataService.getEntityMetadata(this.location, PERSON_METADATA_KEY);
        this.assertFailureResult(result, 1);
        this.assertMetadataFailure((MetadataFailure)result.getFailures().get(0), NOT_A_METADATA_PROVIDER, FailureCode.NO_DYNAMIC_METADATA_AVAILABLE, INVALID_COMPONENT_EXCEPTION_CLASSNAME, MetadataComponent.COMPONENT);
    }

    @Test
    public void failToGetMetadataFromNonExistingConfig() throws IOException {
        this.location = Location.builder().globalName(NON_EXISTING_CONFIG).build();
        MetadataResult result = this.metadataService.getMetadataKeys(this.location);
        this.assertFailureResult(result, 1);
        this.assertMetadataFailure((MetadataFailure)result.getFailures().get(0), String.format(NO_OBJECT_FOUND, NON_EXISTING_CONFIG), FailureCode.COMPONENT_NOT_FOUND, NO_SUCH_COMPONENT_MODEL_EXCEPTION_CLASS_NAME, MetadataComponent.COMPONENT);
    }

    @Test
    public void failToGetMetadataFromDynamicConfig() throws IOException {
        this.location = Location.builder().globalName(DYNAMIC_CONFIG).build();
        MetadataResult result = this.metadataService.getMetadataKeys(this.location);
        this.assertMetadataFailure((MetadataFailure)result.getFailures().get(0), String.format(NO_DYNAMIC_KEY_AVAILABLE, this.location), FailureCode.NO_DYNAMIC_METADATA_AVAILABLE, INVALID_COMPONENT_EXCEPTION_CLASSNAME, MetadataComponent.COMPONENT);
    }

    @Test
    public void processorIsNotMetadataProvider() throws Exception {
        this.location = Location.builder().globalName(LOGGER_FLOW).addProcessorsPart().addIndexPart(0).build();
        MetadataResult result = this.getComponentDynamicMetadata(PERSON_METADATA_KEY);
        this.assertMetadataFailure((MetadataFailure)result.getFailures().get(0), NOT_A_METADATA_PROVIDER, FailureCode.NO_DYNAMIC_METADATA_AVAILABLE, INVALID_COMPONENT_EXCEPTION_CLASSNAME, MetadataComponent.COMPONENT);
    }

    @Test
    public void fetchMissingElementFromCache() throws Exception {
        this.location = Location.builder().globalName("contentOnlyCacheResolver").addProcessorsPart().addIndexPart(0).build();
        MetadataResult result = this.getComponentDynamicMetadata((MetadataKey)NULL_METADATA_KEY);
        this.assertMetadataFailure((MetadataFailure)result.getFailures().get(0), "", FailureCode.RESOURCE_UNAVAILABLE, "", MetadataComponent.INPUT, "content");
    }

    @Test
    public void failWithDynamicConfigurationWhenRetrievingMetadata() throws IOException {
        this.location = Location.builder().globalName("resolverWithDynamicConfig").addProcessorsPart().addIndexPart(0).build();
        MetadataKey key = MultilevelMetadataKeyBuilder.newKey((String)"AMERICA", (String)"continent").withChild(MultilevelMetadataKeyBuilder.newKey((String)"USA", (String)"country").withChild((MetadataKeyBuilder)MultilevelMetadataKeyBuilder.newKey((String)"SFO", (String)"city"))).build();
        MetadataResult result = this.getComponentDynamicMetadata(key);
        this.assertFailureResult(result, 1);
        this.assertMetadataFailure((MetadataFailure)result.getFailures().get(0), CONFIGURATION_CANNOT_BE_DYNAMIC, FailureCode.INVALID_CONFIGURATION, MetadataResolvingException.class.getName(), MetadataComponent.COMPONENT);
    }

    @Test
    public void failToGetMetadataWithMissingMetadataKeyLevels() throws Exception {
        Assume.assumeThat((Object)((Object)this.resolutionType), (Matcher)CoreMatchers.is((Object)((Object)MetadataExtensionFunctionalTestCase.ResolutionType.EXPLICIT_RESOLUTION)));
        this.location = Location.builder().globalName("incompleteMultiLevelKeyResolver").addProcessorsPart().addIndexPart(0).build();
        MetadataKey metadataKey = MultilevelMetadataKeyBuilder.newKey((String)"AMERICA", (String)"continent").withChild((MetadataKeyBuilder)MultilevelMetadataKeyBuilder.newKey((String)"USA", (String)"country")).build();
        MetadataResult result = this.getComponentDynamicMetadata(metadataKey);
        this.assertMetadataFailure((MetadataFailure)result.getFailures().get(0), "Missing levels: [city]", FailureCode.INVALID_METADATA_KEY, "", MetadataComponent.COMPONENT);
    }

    @Test
    public void operationCantResolverVoidAsOutputTypeFromList() throws Exception {
        this.location = Location.builder().globalName("voidListAsOutput").addProcessorsPart().addIndexPart(0).build();
        MetadataResult operationMetadata = this.metadataService.getOperationMetadata(this.location);
        MatcherAssert.assertThat((Object)operationMetadata.isSuccess(), (Matcher)CoreMatchers.is((Object)false));
    }
}

