/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.nb;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.tck.probe.PollingProber;
import org.mule.test.marvel.ironman.IronMan;
import org.mule.test.marvel.model.MissileProofVillain;
import org.mule.test.marvel.model.Villain;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

public class NonBlockingOperationsTestCase
extends AbstractExtensionFunctionalTestCase {
    @Rule
    public ExpectedError expectedException = ExpectedError.none();

    protected String getConfigFile() {
        return "iron-man-config.xml";
    }

    @Test
    public void nonBlockingConnectedOperation() throws Exception {
        this.fireMissileAndAssert("fireMissile");
    }

    @Test
    public void failingNonBlockingConnectedOperation() throws Exception {
        this.expectedException.expectFailingComponent(CoreMatchers.is(this.locator.find(Location.builder().globalName("fireMissile").addProcessorsPart().addIndexPart(1).build()).get()));
        this.expectedException.expectMessage(CoreMatchers.is((Object)"Missile proof"));
        this.expectedException.expectCause(CoreMatchers.instanceOf(UnsupportedOperationException.class));
        MissileProofVillain villain = new MissileProofVillain();
        ((FlowRunner)this.flowRunner("fireMissile").withPayload((Object)villain)).run();
        Assert.assertThat((Object)villain.isAlive(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void nonBlockingOperationReconnection() throws Exception {
        this.fireMissileAndAssert("warMachineFireMissile");
        IronMan warMachine = this.getIronMan("warMachine");
        Assert.assertThat((Object)warMachine.getMissilesFired(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void voidNonBlockingOperation() throws Exception {
        IronMan ironMan = this.getIronMan("ironMan");
        String payload = "take me to the avengers tower";
        CoreEvent event = ((FlowRunner)this.flowRunner("computeFlightPlan").withPayload((Object)"take me to the avengers tower")).run();
        Assert.assertThat((Object)event.getMessage().getPayload().getValue().toString(), (Matcher)CoreMatchers.equalTo((Object)"take me to the avengers tower"));
        new PollingProber();
        PollingProber.probe((long)1000L, (long)1000L, () -> "Go Straight".equals(ironMan.getFlightPlan()));
    }

    private IronMan getIronMan(String name) throws Exception {
        return (IronMan)ExtensionsTestUtils.getConfigurationInstanceFromRegistry((String)name, (CoreEvent)MuleExtensionUtils.getInitialiserEvent(), (MuleContext)muleContext).getValue();
    }

    private void fireMissileAndAssert(String flowName) throws Exception {
        Villain villain = new Villain();
        String result = (String)((FlowRunner)this.flowRunner(flowName).withPayload((Object)villain)).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)villain.isAlive(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)"KABOOM!"));
    }
}

