/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.scopes;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.heisenberg.extension.model.Ricin;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class RoutersExecutionTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final String KILL_REASON = "I'm the one who knocks";
    @Rule
    public SystemProperty maxRedelivery = new SystemProperty("killingReason", "I'm the one who knocks");
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    protected String[] getConfigFiles() {
        return new String[]{"scopes/heisenberg-router-config.xml"};
    }

    protected boolean isDisposeContextPerClass() {
        return true;
    }

    @Test
    public void singleRouteRouter() throws Exception {
        CoreEvent internalEvent = ((FlowRunner)((FlowRunner)this.flowRunner("singleRouteRouter").withPayload((Object)"message")).withAttributes((Object)"other")).run();
        Assert.assertThat((Object)internalEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"message"));
        Assert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("newPayload")).getValue(), (Matcher)CoreMatchers.is((Object)"message"));
        Assert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("newAttributes")).getValue(), (Matcher)CoreMatchers.is((Object)"other"));
    }

    @Test
    public void concurrentRouter() throws Exception {
        CoreEvent internalEvent = this.flowRunner("concurrentRouteExecutor").run();
        Assert.assertThat((Object)internalEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"SUCCESS"));
    }

    @Test
    public void concurrentRouterExecution() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        Latch beginLatch = new Latch();
        CountDownLatch assertLatch = new CountDownLatch(2);
        Consumer<Reference> runner = reference -> {
            try {
                beginLatch.await(10000L, TimeUnit.MILLISECONDS);
                reference.set((Object)((FlowRunner)this.flowRunner("singleRouteRouter").withPayload((Object)"CustomPayload")).run());
                assertLatch.countDown();
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
        };
        Reference first = new Reference();
        Reference second = new Reference();
        executor.submit(() -> runner.accept(first));
        executor.submit(() -> runner.accept(second));
        beginLatch.release();
        assertLatch.await(10000L, TimeUnit.MILLISECONDS);
        CoreEvent firstResult = (CoreEvent)first.get();
        Assert.assertThat((Object)firstResult, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        CoreEvent secondResult = (CoreEvent)second.get();
        Assert.assertThat((Object)secondResult, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)secondResult, (Matcher)CoreMatchers.is((Matcher)IsNot.not((Matcher)CoreMatchers.sameInstance((Object)firstResult))));
        Assert.assertThat((Object)firstResult.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"CustomPayload"));
        Assert.assertThat((Object)secondResult.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"CustomPayload"));
    }

    @Test
    public void twoRoutesRouterWhen() throws Exception {
        CoreEvent internalEvent = ((FlowRunner)((FlowRunner)this.flowRunner("twoRoutesRouter").withVariable("executeWhen", (Object)true)).withVariable("executeOther", (Object)false)).run();
        Assert.assertThat((Object)internalEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"mule:set-payload"));
        Assert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("newPayload")).getValue(), (Matcher)CoreMatchers.is((Object)"mule:set-payload"));
    }

    @Test
    public void twoRoutesRouterOther() throws Exception {
        CoreEvent internalEvent = ((FlowRunner)((FlowRunner)this.flowRunner("twoRoutesRouter").withVariable("executeWhen", (Object)false)).withVariable("executeOther", (Object)true)).run();
        Assert.assertThat((Object)internalEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"mule:set-payload"));
        Assert.assertThat(internalEvent.getVariables().get("newPayload"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat(internalEvent.getVariables().get("newAttributes"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void twoRoutesRouterNone() throws Exception {
        this.expectedException.expectCause(CoreMatchers.instanceOf(ConnectionException.class));
        this.expectedException.expectMessage("No route executed");
        this.runFlow("twoRoutesRouterNone");
    }

    @Test
    public void stereotypedRoutes() throws Exception {
        CoreEvent routeEvent = this.flowRunner("stereotypedRoutes").run();
        Ricin ricin = (Ricin)((List)routeEvent.getMessage().getPayload().getValue()).get(0);
        Assert.assertThat((Object)ricin.getDestination().getVictim(), (Matcher)CoreMatchers.is((Object)"bye bye, someName"));
    }

    @Test
    public void munitSpy() throws Exception {
        CoreEvent internalEvent = this.flowRunner("munitSpy").run();
        Assert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("before")).getValue(), (Matcher)CoreMatchers.is((Object)"true"));
        Assert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("after")).getValue(), (Matcher)CoreMatchers.is((Object)"true"));
    }

    @Test
    public void munitSpyNoBefore() throws Exception {
        CoreEvent internalEvent = this.flowRunner("munitSpyNoBefore").run();
        Assert.assertThat((Object)internalEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"1"));
        Assert.assertThat(internalEvent.getVariables().get("before"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("after")).getValue(), (Matcher)CoreMatchers.is((Object)"true"));
    }

    @Test
    public void munitSpyNoAfter() throws Exception {
        CoreEvent internalEvent = this.flowRunner("munitSpyNoAfter").run();
        Assert.assertThat((Object)internalEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"2"));
        Assert.assertThat((Object)((TypedValue)internalEvent.getVariables().get("before")).getValue(), (Matcher)CoreMatchers.is((Object)"true"));
        Assert.assertThat(internalEvent.getVariables().get("after"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void munitSpyNoAttributes() throws Exception {
        CoreEvent internalEvent = this.flowRunner("munitSpyNoAttributes").run();
        Assert.assertThat((Object)internalEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat(internalEvent.getVariables().get("before"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat(internalEvent.getVariables().get("after"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

