/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.streaming;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.test.module.extension.streaming.AbstractStreamingExtensionTestCase;

@Feature(value="Streaming")
@Story(value="Object Streaming")
public class ObjectStreamingExtensionTestCase
extends AbstractStreamingExtensionTestCase {
    private static final int DATA_SIZE = 100;
    private static final String MY_STREAM_VAR = "myStreamVar";
    private List<String> data;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.data = new ArrayList<String>(100);
        for (int i = 0; i < 100; ++i) {
            this.data.add(RandomStringUtils.randomAlphabetic((int)100));
        }
    }

    protected String getConfigFile() {
        return "objects-streaming-extension-config.xml";
    }

    @Test
    @Description(value="Consume an object stream")
    public void getObjectStream() throws Exception {
        this.assertStreamMatchesData("getStream");
    }

    @Test
    @Description(value="Stores an object stream in a variable leaving without modifying the original payload")
    public void getObjectStreamWithTargetValue() throws Exception {
        CoreEvent event = ((FlowRunner)this.flowRunner("getStreamWithTargetValue").withPayload(this.data)).run();
        Assert.assertThat((Object)((TypedValue)event.getVariables().get(MY_STREAM_VAR)).getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(String.class)));
        Assert.assertThat((Object)((TypedValue)event.getVariables().get(MY_STREAM_VAR)).getValue(), (Matcher)CoreMatchers.equalTo((Object)this.data.get(0)));
    }

    @Test
    @Description(value="Stores an object stream in a variable leaving without modifying the original payload")
    public void getObjectStreamWithTargetVariable() throws Exception {
        CoreEvent event = ((FlowRunner)this.flowRunner("getStreamWithTarget").keepStreamsOpen().withPayload(this.data)).run();
        Assert.assertThat((Object)((TypedValue)event.getVariables().get(MY_STREAM_VAR)).getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(CursorIteratorProvider.class)));
        Assert.assertThat((Object)IteratorUtils.toList((Iterator)((Iterator)((CursorIteratorProvider)((TypedValue)event.getVariables().get(MY_STREAM_VAR)).getValue()).openCursor())), (Matcher)CoreMatchers.equalTo(this.data));
        Assert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(List.class)));
        Assert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo(this.data));
    }

    @Test
    @Description(value="Operation is configured not to stream")
    public void operationWithDisabledStreaming() throws Exception {
        this.assertStreamMatchesData("getStreamWithoutStreaming");
    }

    @Test
    @Description(value="Consume a stream generated in a transaction")
    public void getStreamInTx() throws Exception {
        this.assertStreamMatchesData("getStreamInTx");
    }

    @Test(expected=Exception.class)
    @Description(value="All cursors closed when the flow fails")
    public void allStreamsClosedInCaseOfException() throws Exception {
        ((FlowRunner)this.flowRunner("crashCar").withPayload(this.data)).run();
    }

    @Test(expected=Exception.class)
    @Description(value="All cursors closed when the flow fails in a transaction")
    public void allStreamsClosedInCaseOfExceptionInTx() throws Exception {
        ((FlowRunner)this.flowRunner("crashCarTx").withPayload(this.data)).run();
    }

    private List<String> getStream(String flowName) throws Exception {
        CoreEvent result = ((FlowRunner)this.flowRunner(flowName).withPayload(this.data)).run();
        return (List)result.getMessage().getPayload().getValue();
    }

    private void assertStreamMatchesData(String flowName) throws Exception {
        List<String> actual = this.getStream(flowName);
        Assert.assertThat(actual, (Matcher)CoreMatchers.equalTo(this.data));
    }
}

