/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.values;

import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.runtime.api.value.Value;
import org.mule.test.module.extension.values.AbstractValuesTestCase;

public class ConfigurationValuesTestCase
extends AbstractValuesTestCase {
    protected String getConfigFile() {
        return "values/configuration-values.xml";
    }

    @Test
    public void configWithValues() throws Exception {
        Set<Value> channels = this.getValuesFromConfig("config-with-value", "channel");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)3));
        MatcherAssert.assertThat(channels, this.hasValues("channel1", "channel2", "channel3"));
    }

    @Test
    public void configWithValuesWithRequiredParameters() throws Exception {
        Set<Value> channels = this.getValuesFromConfig("value-with-required-param", "channel");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)2));
        MatcherAssert.assertThat(channels, this.hasValues("required2:value2", "required1:value1"));
    }

    @Test
    public void configWithValuesWithRequiredParamsFromParamGroup() throws Exception {
        Set<Value> channels = this.getValuesFromConfig("values-with-required-params-from-param-group-config", "valueParam");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat(channels, this.hasValues("anyParameter:someValue"));
    }

    @Test
    @Ignore(value="MULE-13786")
    public void configWithValuesWithRequiredParamsFromShowInDslGroup() throws Exception {
        Set<Value> channels = this.getValuesFromConfig("values-with-required-params-from-show-in-dsl-group", "valueParam");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat(channels, this.hasValues("anyParameter:someValue"));
    }
}

