/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.SystemUtils;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class ContentTypeHandlingTestCase
extends AbstractExtensionFunctionalTestCase {
    private static Charset customEncoding;
    @Rule
    public SystemProperty customEncodingProperty = new SystemProperty("customEncoding", customEncoding.name());

    protected String getConfigFile() {
        return "content-type-handling-config.xml";
    }

    protected boolean isDisposeContextPerClass() {
        return true;
    }

    @BeforeClass
    public static void before() throws Exception {
        customEncoding = Charset.defaultCharset().name().equals(StandardCharsets.UTF_8) ? StandardCharsets.ISO_8859_1 : StandardCharsets.UTF_8;
    }

    @Test
    public void setsContentTypeOnXml() throws Exception {
        CoreEvent response = this.runFlow("setsContentTypeOnXml");
        DataType dataType = response.getMessage().getPayload().getDataType();
        this.assertCustomEncoding(dataType);
        Assert.assertThat((Object)dataType.getMediaType().getPrimaryType(), (Matcher)CoreMatchers.is((Object)MediaType.TEXT.getPrimaryType()));
        Assert.assertThat((Object)dataType.getMediaType().getSubType(), (Matcher)CoreMatchers.is((Object)MediaType.TEXT.getSubType()));
    }

    @Test
    public void onlySetEncodingOnXml() throws Exception {
        CoreEvent response = this.runFlow("onlySetEncodingOnXml");
        DataType dataType = response.getMessage().getPayload().getDataType();
        this.assertCustomEncoding(dataType);
    }

    @Test
    public void onlySetMimeTypeOnXml() throws Exception {
        CoreEvent response = this.runFlow("onlySetMimeTypeOnXml");
        DataType dataType = response.getMessage().getPayload().getDataType();
        this.assertDefaultEncoding(dataType);
        this.assertCustomMimeType(dataType);
    }

    @Test
    public void maintainsContentType() throws Exception {
        CoreEvent response = ((FlowRunner)this.flowRunner("defaultContentType").withPayload((Object)"")).run();
        DataType responseDataType = response.getMessage().getPayload().getDataType();
        this.assertDefaultEncoding(responseDataType);
        this.assertDefaultMimeType(responseDataType);
    }

    @Test
    public void setEncodingInMimeTypeAndParam() throws Exception {
        CoreEvent response = this.runFlow("setEncodingInMimeTypeAndParam");
        DataType dataType = response.getMessage().getPayload().getDataType();
        Assert.assertThat((Object)dataType.getMediaType().getPrimaryType(), (Matcher)CoreMatchers.is((Object)"application"));
        Assert.assertThat((Object)dataType.getMediaType().getSubType(), (Matcher)CoreMatchers.is((Object)"json"));
        Assert.assertThat(dataType.getMediaType().getCharset().get(), (Matcher)CoreMatchers.is((Object)StandardCharsets.UTF_16));
    }

    @Test
    public void overridesContentType() throws Exception {
        Charset lastSupportedEncoding = Charset.availableCharsets().values().stream().reduce((first, last) -> last).get();
        CoreEvent response = this.runFlow("setsContentTypeProgrammatically");
        DataType dataType = response.getMessage().getPayload().getDataType();
        this.assertCustomMimeType(dataType);
        Assert.assertThat(dataType.getMediaType().getCharset().get(), (Matcher)CoreMatchers.is((Object)lastSupportedEncoding));
    }

    @Test
    public void strictMimeType() throws Exception {
        CoreEvent response = this.runFlow("strictMimeType");
        Assert.assertThat((Object)response.getMessage().getPayload().getDataType().getMediaType().matches(MediaType.TEXT), (Matcher)CoreMatchers.is((Object)true));
    }

    private void assertCustomMimeType(DataType dataType) {
        Assert.assertThat((Object)dataType.getMediaType().getPrimaryType(), (Matcher)CoreMatchers.is((Object)"dead"));
        Assert.assertThat((Object)dataType.getMediaType().getSubType(), (Matcher)CoreMatchers.is((Object)"dead"));
    }

    private void assertCustomEncoding(DataType dataType) {
        Assert.assertThat(dataType.getMediaType().getCharset().get(), (Matcher)CoreMatchers.is((Object)customEncoding));
    }

    private void assertDefaultEncoding(DataType dataType) throws Exception {
        Assert.assertThat(dataType.getMediaType().getCharset().get(), (Matcher)CoreMatchers.is((Object)SystemUtils.getDefaultEncoding((MuleContext)muleContext)));
    }

    private void assertDefaultMimeType(DataType dataType) throws Exception {
        Assert.assertThat((Object)dataType.getMediaType().getPrimaryType(), (Matcher)CoreMatchers.is((Object)this.getDefaultDataType().getMediaType().getPrimaryType()));
        Assert.assertThat((Object)dataType.getMediaType().getSubType(), (Matcher)CoreMatchers.is((Object)this.getDefaultDataType().getMediaType().getSubType()));
    }

    private DataType getDefaultDataType() {
        FlowRunner runner = (FlowRunner)this.flowRunner("defaultContentType").withPayload((Object)"");
        return runner.buildEvent().getMessage().getPayload().getDataType();
    }
}

