/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsMapContaining;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.matchers.ThrowableRootCauseMatcher;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.extension.api.runtime.parameter.ParameterResolver;
import org.mule.tck.junit4.matcher.DataTypeCompatibilityMatcher;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.heisenberg.extension.exception.HealthException;
import org.mule.test.heisenberg.extension.exception.HeisenbergException;
import org.mule.test.heisenberg.extension.model.BarberPreferences;
import org.mule.test.heisenberg.extension.model.CarDealer;
import org.mule.test.heisenberg.extension.model.CarWash;
import org.mule.test.heisenberg.extension.model.HealthStatus;
import org.mule.test.heisenberg.extension.model.Investment;
import org.mule.test.heisenberg.extension.model.KnockeableDoor;
import org.mule.test.heisenberg.extension.model.PersonalInfo;
import org.mule.test.heisenberg.extension.model.Ricin;
import org.mule.test.heisenberg.extension.model.SaleInfo;
import org.mule.test.heisenberg.extension.model.Weapon;
import org.mule.test.heisenberg.extension.model.types.IntegerAttributes;
import org.mule.test.heisenberg.extension.model.types.WeaponType;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

public class OperationExecutionTestCase
extends AbstractExtensionFunctionalTestCase {
    public static final String HEISENBERG = "heisenberg";
    public static final String KILL_RESULT = String.format("Killed with: %s , Type %s and attribute %s", "You have been killed with Ricin", WeaponType.MELEE_WEAPON.name(), "Pizza on the rooftop");
    private static final String GUSTAVO_FRING = "Gustavo Fring";
    private static final String GOODBYE_MESSAGE = "Say hello to my little friend";
    private static final String VICTIM = "Skyler";
    private static final String EMPTY_STRING = "";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    protected String[] getConfigFiles() {
        return new String[]{"heisenberg-operation-config.xml", "vegan-config.xml"};
    }

    protected boolean isDisposeContextPerClass() {
        return true;
    }

    @Test
    public void operationWithReturnValueAndWithoutParameters() throws Exception {
        Assert.assertThat((Object)HEISENBERG, (Matcher)CoreMatchers.equalTo((Object)this.runFlow("sayMyName").getMessage().getPayload().getValue()));
    }

    @Test
    public void operationWithReturnValueOnTarget() throws Exception {
        FlowRunner runner = (FlowRunner)this.flowRunner("sayMyNameOnTarget").withPayload((Object)EMPTY_STRING);
        CoreEvent responseEvent = runner.run();
        Assert.assertThat((Object)responseEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)EMPTY_STRING));
        Message responseMessage = (Message)((TypedValue)responseEvent.getVariables().get("myFace")).getValue();
        Assert.assertThat((Object)responseMessage.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)HEISENBERG));
    }

    @Test
    public void getInlineGroupDefinition() throws Exception {
        Message message = ((FlowRunner)this.flowRunner("getBarberPreferences").withPayload((Object)EMPTY_STRING)).run().getMessage();
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)message.getPayload().getDataType().getMediaType().matches(MediaType.APPLICATION_JAVA), (Matcher)CoreMatchers.is((Object)true));
        BarberPreferences preferences = (BarberPreferences)message.getPayload().getValue();
        Assert.assertThat((Object)preferences.getBeardTrimming(), (Matcher)CoreMatchers.is((Object)BarberPreferences.BEARD_KIND.MUSTACHE));
        Assert.assertThat((Object)preferences.isFullyBald(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void getInlineGroupDefinitionAsArgument() throws Exception {
        Message message = ((FlowRunner)this.flowRunner("getInlineInfo").withPayload((Object)EMPTY_STRING)).run().getMessage();
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        BarberPreferences preferences = (BarberPreferences)message.getPayload().getValue();
        Assert.assertThat((Object)preferences.getBeardTrimming(), (Matcher)CoreMatchers.is((Object)BarberPreferences.BEARD_KIND.MUSTACHE));
        Assert.assertThat((Object)preferences.isFullyBald(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void getInlineGroupPersonalInfoAsArgument() throws Exception {
        Message message = ((FlowRunner)this.flowRunner("getInlinePersonalInfo").withPayload((Object)EMPTY_STRING)).run().getMessage();
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        PersonalInfo value = (PersonalInfo)message.getPayload().getValue();
        Assert.assertThat((Object)value.getAge(), (Matcher)CoreMatchers.is((Object)26));
        Assert.assertThat(value.getKnownAddresses().get(0), (Matcher)CoreMatchers.is((Object)"explicitAddress"));
        Assert.assertThat((Object)value.getName(), (Matcher)CoreMatchers.is((Object)"Pepe"));
    }

    @Test
    public void voidOperationWithoutParameters() throws Exception {
        CoreEvent responseEvent = ((FlowRunner)this.flowRunner("die").withPayload((Object)EMPTY_STRING)).run();
        Assert.assertThat((Object)responseEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)EMPTY_STRING));
        Assert.assertThat((Object)this.getConfig(HEISENBERG).getEndingHealth(), (Matcher)CoreMatchers.is((Object)HealthStatus.DEAD));
    }

    @Test
    public void operationWithFixedParameter() throws Exception {
        Assert.assertThat((Object)GUSTAVO_FRING, (Matcher)CoreMatchers.equalTo((Object)this.runFlow("getFixedEnemy").getMessage().getPayload().getValue()));
    }

    @Test
    public void operationWithDefaulValueParameter() throws Exception {
        Assert.assertThat((Object)GUSTAVO_FRING, (Matcher)CoreMatchers.equalTo((Object)this.runFlow("getDefaultEnemy").getMessage().getPayload().getValue()));
    }

    @Test
    public void operationWhichReturnsListOfMessages() throws Exception {
        TypedValue payload = this.runFlow("getAllEnemies").getMessage().getPayload();
        Assert.assertThat((Object)payload.getDataType(), (Matcher)CoreMatchers.is((Matcher)DataTypeCompatibilityMatcher.assignableTo((DataType)DataType.MULE_MESSAGE_COLLECTION)));
        List enemies = (List)payload.getValue();
        HeisenbergExtension heisenberg = this.getConfig(HEISENBERG);
        Assert.assertThat((Object)enemies, (Matcher)Matchers.hasSize((int)heisenberg.getEnemies().size()));
        int index = 0;
        for (Message enemyMessage : enemies) {
            this.assertEnemyMessage(heisenberg, index, enemyMessage);
            ++index;
        }
    }

    private void assertEnemyMessage(HeisenbergExtension heisenberg, int index, Message enemyMessage) {
        Assert.assertThat((Object)enemyMessage.getPayload().getValue(), (Matcher)CoreMatchers.is(heisenberg.getEnemies().get(index)));
        Assert.assertThat((Object)enemyMessage.getAttributes().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(IntegerAttributes.class)));
        Assert.assertThat((Object)((IntegerAttributes)enemyMessage.getAttributes().getValue()).getValue(), (Matcher)CoreMatchers.is((Object)index));
    }

    @Test
    public void randomAccessOnOperationWhichReturnsListOfMessages() throws Exception {
        List enemies = (List)this.runFlow("getAllEnemies").getMessage().getPayload().getValue();
        HeisenbergExtension heisenberg = this.getConfig(HEISENBERG);
        Assert.assertThat((Object)enemies, (Matcher)Matchers.hasSize((int)heisenberg.getEnemies().size()));
        int index = enemies.size() - 1;
        this.assertEnemyMessage(heisenberg, index, (Message)enemies.get(index));
        index = 0;
        this.assertEnemyMessage(heisenberg, index, (Message)enemies.get(index));
    }

    @Test
    public void operationWithDynamicParameter() throws Exception {
        this.doTestExpressionEnemy(0);
    }

    @Test
    public void operationWithTransformedParameter() throws Exception {
        this.doTestExpressionEnemy("0");
    }

    @Test
    public void parameterFixedAtPayload() throws Exception {
        this.assertKillByPayload("killFromPayload");
    }

    @Test
    public void optionalParameterDefaultingToPayload() throws Exception {
        this.assertKillByPayload("customKillWithDefault");
    }

    @Test
    public void optionalParameterWithDefaultOverride() throws Exception {
        CoreEvent event = ((FlowRunner)((FlowRunner)((FlowRunner)this.flowRunner("customKillWithoutDefault").withPayload((Object)EMPTY_STRING)).withVariable("goodbye", (Object)GOODBYE_MESSAGE)).withVariable("victim", (Object)VICTIM)).run();
        this.assertKillPayload(event);
    }

    @Test
    public void getInjectedDependency() throws Exception {
        ExtensionManager extensionManager = (ExtensionManager)this.runFlow("injectedExtensionManager").getMessage().getPayload().getValue();
        Assert.assertThat((Object)extensionManager, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)muleContext.getExtensionManager())));
    }

    @Test
    public void alias() throws Exception {
        String alias = (String)this.runFlow("alias").getMessage().getPayload().getValue();
        Assert.assertThat((Object)alias, (Matcher)CoreMatchers.is((Object)"Howdy!, my name is Walter White and I'm 52 years old"));
    }

    @Test
    public void operationWithStaticInlinePojoParameter() throws Exception {
        String response = this.getPayloadAsString(this.runFlow("knockStaticInlineDoor").getMessage());
        this.assertKnockedDoor(response, "Inline Skyler");
    }

    @Test
    public void operationWithRequiredParameterButNullReturningExpression() throws Exception {
        this.expectedException.expect(ThrowableRootCauseMatcher.hasRootCause((Matcher)CoreMatchers.instanceOf(IllegalArgumentException.class)));
        this.runFlow("knockWithNullDoor");
    }

    @Test
    public void operationWithDynamicInlinePojoParameter() throws Exception {
        this.assertDynamicDoor("knockDynamicInlineDoor");
    }

    @Test
    public void operationWithStaticTopLevelPojoParameter() throws Exception {
        String response = this.getPayloadAsString(this.runFlow("knockStaticTopLevelDoor").getMessage());
        this.assertKnockedDoor(response, "Top Level Skyler");
    }

    @Test
    public void operationWithDynamicTopLevelPojoParameter() throws Exception {
        this.assertDynamicDoor("knockDynamicTopLevelDoor");
    }

    @Test
    public void operationWithInlineListParameter() throws Exception {
        List response = (List)((FlowRunner)((FlowRunner)this.flowRunner("knockManyWithInlineList").withPayload((Object)EMPTY_STRING)).withVariable("victim", (Object)"Saul")).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)response, (Matcher)Matchers.contains((Object[])new String[]{KnockeableDoor.knock((String)"Inline Skyler"), KnockeableDoor.knock((String)"Saul")}));
    }

    @Test
    public void operationWithExpressionListParameter() throws Exception {
        List<KnockeableDoor> doors = Arrays.asList(new KnockeableDoor(VICTIM), new KnockeableDoor("Saul"));
        List response = (List)((FlowRunner)((FlowRunner)this.flowRunner("knockManyByExpression").withPayload((Object)EMPTY_STRING)).withVariable("doors", doors)).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)response, (Matcher)Matchers.contains((Object[])new String[]{KnockeableDoor.knock((String)VICTIM), KnockeableDoor.knock((String)"Saul")}));
    }

    @Test
    public void operationWhichRequiresConnection() throws Exception {
        Assert.assertThat((Object)this.getPayloadAsString(this.runFlow("callSaul").getMessage()), (Matcher)CoreMatchers.is((Object)"You called 505-503-4455"));
    }

    @Test
    public void extensionWithExceptionEnricher() throws Throwable {
        this.expectedException.expect(ConnectionException.class);
        this.expectedException.expectMessage(CoreMatchers.is((Object)"Enriched Connection Exception: You are not allowed to speak with gus."));
        this.runFlowAndThrowCause("callGus");
    }

    @Test
    public void operationWithExceptionEnricher() throws Throwable {
        this.expectedException.expect(HeisenbergException.class);
        this.expectedException.expectCause(CoreMatchers.is((Matcher)CoreMatchers.instanceOf(HealthException.class)));
        this.expectedException.expectMessage(CoreMatchers.containsString((String)"Can't help you, you are going to die"));
        this.runFlowAndThrowCause("cureCancer");
    }

    private void runFlowAndThrowCause(String callGus) throws Throwable {
        throw this.flowRunner(callGus).runExpectingException().getCause();
    }

    @Test
    public void operationWhichConsumesANonInstantiableArgument() throws Exception {
        Ricin ricinWeapon = new Ricin();
        ricinWeapon.setMicrogramsPerKilo(10L);
        CoreEvent event = ((FlowRunner)((FlowRunner)this.flowRunner("killWithWeapon").withPayload((Object)EMPTY_STRING)).withVariable("weapon", (Object)ricinWeapon)).run();
        Assert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)KILL_RESULT));
    }

    @Test
    public void connectionProviderDefaultValueSaulPhoneNumber() throws Exception {
        CoreEvent getSaulNumber = this.runFlow("getSaulNumber");
        Assert.assertThat((Object)getSaulNumber.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"505-503-4455"));
    }

    @Test
    public void operationWhichConsumesAListOfNonInstantiableArgument() throws Exception {
        Ricin ricinWeapon1 = new Ricin();
        ricinWeapon1.setMicrogramsPerKilo(10L);
        Ricin ricinWeapon2 = new Ricin();
        ricinWeapon2.setMicrogramsPerKilo(10L);
        List<Weapon> weaponList = Arrays.asList(ricinWeapon1, ricinWeapon2);
        CoreEvent event = ((FlowRunner)((FlowRunner)this.flowRunner("killWithMultipleWeapons").withPayload((Object)EMPTY_STRING)).withVariable("weapons", weaponList)).run();
        List result = weaponList.stream().map(Weapon::kill).collect(Collectors.toList());
        Assert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is(result));
    }

    @Test
    public void operationWithListPojoAsDefaultPayload() throws Exception {
        Ricin ricinWeapon1 = new Ricin();
        ricinWeapon1.setMicrogramsPerKilo(20L);
        Ricin ricinWeapon2 = new Ricin();
        ricinWeapon2.setMicrogramsPerKilo(22L);
        List ricins = (List)((FlowRunner)this.flowRunner("killWithRicinDefaultPayload").withPayload(Arrays.asList(ricinWeapon1, ricinWeapon2))).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)ricins, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat(ricins.get(0), (Matcher)CoreMatchers.instanceOf(Ricin.class));
        Assert.assertThat(ricins.get(1), (Matcher)CoreMatchers.instanceOf(Ricin.class));
        Ricin ricin1 = (Ricin)ricins.get(0);
        Assert.assertThat((Object)ricin1.getMicrogramsPerKilo(), (Matcher)CoreMatchers.is((Object)20L));
        Ricin ricin2 = (Ricin)ricins.get(1);
        Assert.assertThat((Object)ricin2.getMicrogramsPerKilo(), (Matcher)CoreMatchers.is((Object)22L));
    }

    @Test
    public void operationWithListPojoAsChildElementsOverridesDefault() throws Exception {
        List ricins = (List)((FlowRunner)this.flowRunner("killWithRicinAsChildElement").withPayload((Object)EMPTY_STRING)).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)ricins, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat(ricins.get(0), (Matcher)CoreMatchers.instanceOf(Ricin.class));
        Assert.assertThat(ricins.get(1), (Matcher)CoreMatchers.instanceOf(Ricin.class));
        Ricin ricin1 = (Ricin)ricins.get(0);
        Assert.assertThat((Object)ricin1.getMicrogramsPerKilo(), (Matcher)CoreMatchers.is((Object)20L));
        Assert.assertThat((Object)ricin1.getDestination().getVictim(), (Matcher)CoreMatchers.is((Object)"Lidia"));
        Assert.assertThat((Object)ricin1.getDestination().getAddress(), (Matcher)CoreMatchers.is((Object)"Stevia coffe shop"));
        Ricin ricin2 = (Ricin)ricins.get(1);
        Assert.assertThat((Object)ricin2.getMicrogramsPerKilo(), (Matcher)CoreMatchers.is((Object)22L));
        Assert.assertThat((Object)ricin2.getDestination().getVictim(), (Matcher)CoreMatchers.is((Object)GUSTAVO_FRING));
        Assert.assertThat((Object)ricin2.getDestination().getAddress(), (Matcher)CoreMatchers.is((Object)"pollos hermanos"));
    }

    @Test
    public void operationWithParameterResolver() throws Exception {
        Object value = ((FlowRunner)this.flowRunner("literalEcho").withPayload((Object)EMPTY_STRING)).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.equalTo((Object)"#[money]"));
    }

    @Test
    public void getMedicalHistory() throws Exception {
        Map getMedicalHistory = (Map)this.flowRunner("getMedicalHistory").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)getMedicalHistory, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)getMedicalHistory.entrySet().size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat(getMedicalHistory.get("2013"), (Matcher)CoreMatchers.is((Object)HealthStatus.HEALTHY));
        Assert.assertThat(getMedicalHistory.get("2014"), (Matcher)CoreMatchers.is((Object)HealthStatus.CANCER));
        Assert.assertThat(getMedicalHistory.get("2015"), (Matcher)CoreMatchers.is((Object)HealthStatus.DEAD));
    }

    @Test
    public void getGramsInStorage() throws Exception {
        int[][] gramsInStorage = (int[][])((FlowRunner)this.flowRunner("getGramsInStorage").withPayload((Object)new int[][]{{0, 22}, {1, 10}, {2, 30}})).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)gramsInStorage[0][0], (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)gramsInStorage[0][1], (Matcher)CoreMatchers.is((Object)22));
        Assert.assertThat((Object)gramsInStorage[1][0], (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)gramsInStorage[1][1], (Matcher)CoreMatchers.is((Object)10));
        Assert.assertThat((Object)gramsInStorage[2][0], (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)gramsInStorage[2][1], (Matcher)CoreMatchers.is((Object)30));
    }

    @Test
    public void abstractParameterWithSubtypesAndParameterGroup() throws Exception {
        Investment investment = (Investment)this.flowRunner("investment").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)investment, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(CarWash.class)));
        CarWash carWash = (CarWash)investment;
        Assert.assertThat((Object)carWash.getCommercialName(), (Matcher)CoreMatchers.is((Object)"A1"));
        Assert.assertThat((Object)carWash.getInvestmentInfo(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)carWash.getInvestmentInfo().getValuation(), (Matcher)CoreMatchers.equalTo((Object)100L));
        Assert.assertThat((Object)carWash.getCarsPerMinute(), (Matcher)CoreMatchers.is((Object)5));
        Assert.assertThat((Object)carWash.isApproved(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)carWash.getInvestmentSpinOffs(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat(carWash.getInvestmentSpinOffs().get("other-car-wash"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(CarWash.class)));
        CarWash spinOff = (CarWash)carWash.getInvestmentSpinOffs().get("other-car-wash");
        Assert.assertThat((Object)spinOff.getCommercialName(), (Matcher)CoreMatchers.is((Object)"B1"));
        Assert.assertThat((Object)spinOff.getInvestmentInfo(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)spinOff.getInvestmentInfo().getValuation(), (Matcher)CoreMatchers.equalTo((Object)10L));
        Assert.assertThat((Object)spinOff.getCarsPerMinute(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)spinOff.getDiscardedInvestments(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)spinOff.getDiscardedInvestments().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(spinOff.getDiscardedInvestments().get(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(CarDealer.class)));
        CarDealer discarded = (CarDealer)spinOff.getDiscardedInvestments().get(0);
        Assert.assertThat((Object)discarded.getCommercialName(), (Matcher)CoreMatchers.is((Object)"Premium Cars"));
        Assert.assertThat((Object)discarded.getCarStock(), (Matcher)CoreMatchers.is((Object)50));
        Assert.assertThat((Object)discarded.getInvestmentInfo(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)discarded.getInvestmentInfo().getValuation(), (Matcher)CoreMatchers.equalTo((Object)666L));
        Assert.assertThat((Object)discarded.getInvestmentInfo().getInvestmentPlanB(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(CarDealer.class)));
        CarDealer planB = (CarDealer)discarded.getInvestmentInfo().getInvestmentPlanB();
        Assert.assertThat((Object)planB.getCommercialName(), (Matcher)CoreMatchers.is((Object)"Not So Premium Cars"));
        Assert.assertThat((Object)planB.getCarStock(), (Matcher)CoreMatchers.is((Object)5));
        Assert.assertThat((Object)planB.getInvestmentInfo(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)planB.getInvestmentInfo().getValuation(), (Matcher)CoreMatchers.equalTo((Object)333L));
    }

    @Test
    public void operationWithMapOfComplexType() throws Exception {
        String dean = "Dean";
        Map salesInfo = (Map)this.flowRunner("processSale").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)salesInfo, (Matcher)IsMapContaining.hasKey((Object)"Dean"));
        SaleInfo saleInfo = (SaleInfo)salesInfo.get("Dean");
        Assert.assertThat((Object)saleInfo.getAmount(), (Matcher)CoreMatchers.is((Object)500));
        Assert.assertThat((Object)saleInfo.getDetails(), (Matcher)CoreMatchers.is((Object)"Some detail"));
    }

    @Test
    public void listOfMapsAsParameter() throws Exception {
        String expectedMessage = "an Apple";
        ArrayList listOfMaps = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(Apple.class.getSimpleName(), expectedMessage);
        listOfMaps.add(map);
        CoreEvent event = ((FlowRunner)this.flowRunner("eatComplexListOfMaps").withPayload(listOfMaps)).run();
        List result = (List)event.getMessage().getPayload().getValue();
        Assert.assertThat((Object)result, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(((Map)result.get(0)).get(Apple.class.getSimpleName()), (Matcher)CoreMatchers.is((Object)expectedMessage));
    }

    @Test
    public void operationWithInputStreamContentParameterInParameterGroup() throws Exception {
        String theMessage = "This is an important message";
        Object result = ((FlowRunner)this.flowRunner("operationWithInputStreamContentParam").withVariable("msg", (Object)new ByteArrayInputStream(theMessage.getBytes()))).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)theMessage));
    }

    @Test
    public void executeOperationWithExtensionsClient() throws Exception {
        String result = (String)this.flowRunner("withClient").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)"ADIOS, Juani"));
    }

    @Test
    public void operationWithAliasedParametersAsChild() throws Exception {
        Map value = (Map)this.flowRunner("operationWithAliasedParametersAsChild").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Matcher)IsMapContaining.hasEntry((Matcher)CoreMatchers.is((Object)"SomeName"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Ricin.class)))));
    }

    @Test
    public void operationWithAliasedParametersAsReference() throws Exception {
        Map value = (Map)this.flowRunner("operationWithAliasedParametersAsChild").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Matcher)IsMapContaining.hasEntry((Matcher)CoreMatchers.is((Object)"SomeName"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Ricin.class)))));
    }

    @Test
    public void aliasedOperation() throws Exception {
        ParameterResolver result = (ParameterResolver)this.flowRunner("aliasedOperation").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)result.resolve(), (Matcher)CoreMatchers.is((Object)"an expression"));
    }

    private void assertDynamicDoor(String flowName) throws Exception {
        this.assertDynamicVictim(flowName, VICTIM);
        this.assertDynamicVictim(flowName, "Saul");
    }

    private void assertDynamicVictim(String flowName, String victim) throws Exception {
        this.assertKnockedDoor(this.getPayloadAsString(((FlowRunner)((FlowRunner)this.flowRunner(flowName).withPayload((Object)EMPTY_STRING)).withVariable("victim", (Object)victim)).run().getMessage()), victim);
    }

    private void assertKnockedDoor(String actual, String expected) {
        Assert.assertThat((Object)actual, (Matcher)CoreMatchers.is((Object)KnockeableDoor.knock((String)expected)));
    }

    private void assertKillPayload(CoreEvent event) throws MuleException {
        Assert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)String.format("%s, %s", GOODBYE_MESSAGE, VICTIM)));
    }

    private void assertKillByPayload(String flowName) throws Exception {
        this.assertKillPayload(((FlowRunner)((FlowRunner)this.flowRunner(flowName).withPayload((Object)VICTIM)).withVariable("goodbye", (Object)GOODBYE_MESSAGE)).run());
    }

    private void doTestExpressionEnemy(Object enemyIndex) throws Exception {
        CoreEvent event = ((FlowRunner)((FlowRunner)this.flowRunner("expressionEnemy").withPayload((Object)EMPTY_STRING)).withVariable("enemy", enemyIndex)).run();
        Assert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)GUSTAVO_FRING));
    }

    private HeisenbergExtension getConfig(String name) throws Exception {
        return (HeisenbergExtension)ExtensionsTestUtils.getConfigurationFromRegistry((String)name, (CoreEvent)CoreEvent.builder((CoreEvent)this.testEvent()).message(Message.of((Object)EMPTY_STRING)).build(), (MuleContext)muleContext);
    }
}

