/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.metadata;

import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class ConfigMetadataKeysTestCase
extends AbstractExtensionFunctionalTestCase {
    public static final String VEGAN_CONFIG_XML = "vegan-config.xml";
    public static final String HARVEST_APPLE_KEY_RESOLVER_KEYS = "HarvestAppleKeyResolver.keys";
    @Inject
    private MetadataService metadataManager;
    private File keysOverride;

    protected String getConfigFile() {
        return VEGAN_CONFIG_XML;
    }

    @Before
    public void setUp() throws Exception {
        this.keysOverride = new File(((Object)((Object)this)).getClass().getClassLoader().getResource(HARVEST_APPLE_KEY_RESOLVER_KEYS).getPath());
        FileUtils.writeStringToFile((File)this.keysOverride, (String)"");
    }

    @After
    public void tearDown() throws Exception {
        FileUtils.writeStringToFile((File)this.keysOverride, (String)"");
    }

    @Test
    public void getMetadataKeysForConfig() throws Exception {
        MetadataResult metadataKeysResult = this.metadataManager.getMetadataKeys(Location.builder().globalName("apple").build());
        Assert.assertThat((Object)metadataKeysResult.isSuccess(), (Matcher)Is.is((Object)true));
        Map<String, Set<MetadataKey>> metadataKeys = this.getKeyMapFromContainer((MetadataResult<MetadataKeysContainer>)metadataKeysResult);
        Assert.assertThat((Object)metadataKeys.size(), (Matcher)Is.is((Object)1));
        Set<MetadataKey> harvestedKeys = metadataKeys.get("HarvestedKeys");
        Assert.assertThat((Object)harvestedKeys.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)harvestedKeys.iterator().next().getId(), (Matcher)Is.is((Object)"HARVESTED"));
    }

    @Test
    public void getMetadataKeysForConfigFromResources() throws Exception {
        FileUtils.writeStringToFile((File)this.keysOverride, (String)"LOADED,OVERRIDE,HARVEST");
        MetadataResult metadataKeysResult = this.metadataManager.getMetadataKeys(Location.builder().globalName("apple").build());
        Assert.assertThat((Object)metadataKeysResult.isSuccess(), (Matcher)Is.is((Object)true));
        Map<String, Set<MetadataKey>> metadataKeys = this.getKeyMapFromContainer((MetadataResult<MetadataKeysContainer>)metadataKeysResult);
        Assert.assertThat((Object)metadataKeys.size(), (Matcher)Is.is((Object)1));
        Set<MetadataKey> harvestedKeys = metadataKeys.get("HarvestedKeys");
        Assert.assertThat((Object)harvestedKeys.size(), (Matcher)Is.is((Object)3));
        Assert.assertThat(harvestedKeys.stream().map(MetadataKey::getId).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"LOADED", "OVERRIDE", "HARVEST"}));
    }

    @Test
    public void getMetadataKeysForConfigWithoutResolvers() throws Exception {
        MetadataResult metadataKeysResult = this.metadataManager.getMetadataKeys(Location.builder().globalName("banana").build());
        Assert.assertThat((Object)metadataKeysResult.isSuccess(), (Matcher)Is.is((Object)true));
        Map<String, Set<MetadataKey>> metadataKeys = this.getKeyMapFromContainer((MetadataResult<MetadataKeysContainer>)metadataKeysResult);
        Assert.assertThat((Object)metadataKeys.isEmpty(), (Matcher)Is.is((Object)true));
    }

    private Map<String, Set<MetadataKey>> getKeyMapFromContainer(MetadataResult<MetadataKeysContainer> metadataKeysResult) {
        return ((MetadataKeysContainer)metadataKeysResult.get()).getCategories().stream().collect(Collectors.toMap(resolver -> resolver, resolver -> (Set)((MetadataKeysContainer)metadataKeysResult.get()).getKeys(resolver).get()));
    }
}

