/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.metadata;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Map;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.metadata.MetadataCache;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.test.module.extension.metadata.AbstractMetadataOperationTestCase;
import org.mule.test.module.extension.metadata.MetadataExtensionFunctionalTestCase;

public class MetadataCacheTestCase
extends AbstractMetadataOperationTestCase {
    private static final String CONFIG = "config";
    private static final String ALTERNATIVE_CONFIG = "alternative-config";
    @Inject
    private MetadataService metadataManager;

    public MetadataCacheTestCase(MetadataExtensionFunctionalTestCase.ResolutionType resolutionType) {
        super(resolutionType);
    }

    protected String getConfigFile() {
        return "metadata-runtime-tests.xml";
    }

    @Override
    public boolean enableLazyInit() {
        return false;
    }

    @Override
    public boolean disableXmlValidations() {
        return false;
    }

    @Test
    public void multipleCaches() throws Exception {
        Map<String, ? extends MetadataCache> caches = this.getMetadataCaches(this.metadataManager);
        caches.keySet().forEach(arg_0 -> ((MetadataService)this.metadataManager).disposeCache(arg_0));
        this.location = Location.builder().globalName("outputAndMetadataKeyCacheResolver").addProcessorsPart().addIndexPart(0).build();
        this.getSuccessComponentDynamicMetadata(PERSON_METADATA_KEY);
        this.location = Location.builder().globalName("outputMetadataWithoutKeyId").addProcessorsPart().addIndexPart(0).build();
        this.getSuccessComponentDynamicMetadata((MetadataKey)NULL_METADATA_KEY);
        this.location = Location.builder().globalName("contentAndOutputWithCacheResolverWithSpecificConfig").addProcessorsPart().addIndexPart(0).build();
        this.getSuccessComponentDynamicMetadata(PERSON_METADATA_KEY);
        caches = this.getMetadataCaches(this.metadataManager);
        MatcherAssert.assertThat(caches.keySet(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(caches.keySet(), (Matcher)Matchers.hasItems((Object[])new String[]{CONFIG, ALTERNATIVE_CONFIG}));
    }

    @Test
    public void elementsAreStoredInCaches() throws Exception {
        this.location = Location.builder().globalName("outputAndMetadataKeyCacheResolver").addProcessorsPart().addIndexPart(0).build();
        this.metadataService.getMetadataKeys(this.location);
        this.getSuccessComponentDynamicMetadata(PERSON_METADATA_KEY);
        this.location = Location.builder().globalName("contentAndOutputWithCacheResolverWithSpecificConfig").addProcessorsPart().addIndexPart(0).build();
        this.getSuccessComponentDynamicMetadata();
        MetadataCache configCache = this.getMetadataCaches(this.metadataManager).get(CONFIG);
        MatcherAssert.assertThat(configCache.get((Serializable)((Object)"Age")).get(), (Matcher)Is.is((Object)16));
        MatcherAssert.assertThat(configCache.get((Serializable)((Object)"Name")).get(), (Matcher)Is.is((Object)"Juan"));
        MatcherAssert.assertThat(configCache.get((Serializable)((Object)"Brand")).get(), (Matcher)Is.is((Object)"Nikdidas"));
        MetadataCache alternativeConfigCache = this.getMetadataCaches(this.metadataManager).get(ALTERNATIVE_CONFIG);
        MatcherAssert.assertThat(alternativeConfigCache.get((Serializable)((Object)"Brand")).get(), (Matcher)Is.is((Object)"Nikdidas"));
    }

    private Map<String, ? extends MetadataCache> getMetadataCaches(MetadataService metadataManager) {
        try {
            Method getMetadataCachesMethod = metadataManager.getClass().getMethod("getMetadataCaches", new Class[0]);
            return (Map)getMetadataCachesMethod.invoke((Object)metadataManager, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot obtain metadata caches", e);
        }
    }
}

