/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.reconnection;

import java.util.LinkedList;
import java.util.List;
import org.junit.Test;
import org.mule.extension.test.extension.reconnection.ReconnectableConnection;
import org.mule.extension.test.extension.reconnection.ReconnectableConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.tck.probe.PollingProber;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class ReconnectionTestCase
extends AbstractExtensionFunctionalTestCase {
    private static List<CoreEvent> capturedEvents;

    protected String getConfigFile() {
        return "reconnection-config.xml";
    }

    protected void doSetUp() throws Exception {
        capturedEvents = new LinkedList<CoreEvent>();
        ReconnectableConnectionProvider.fail = false;
    }

    protected void doTearDown() throws Exception {
        capturedEvents = null;
        ReconnectableConnectionProvider.fail = false;
    }

    @Test
    public void reconnectSource() throws Exception {
        ((Startable)this.getFlowConstruct("reconnectForever")).start();
        PollingProber.check((long)5000L, (long)1000L, () -> !capturedEvents.isEmpty());
        this.switchConnection();
        PollingProber.check((long)10000L, (long)1000L, () -> {
            List<CoreEvent> list = capturedEvents;
            synchronized (list) {
                return capturedEvents.stream().map(event -> (ReconnectableConnection)event.getMessage().getPayload().getValue()).filter(c -> c.getReconnectionAttempts() >= 3).findAny().isPresent();
            }
        });
    }

    private void switchConnection() throws Exception {
        this.flowRunner("switchConnection").run();
    }

    public static class CaptureProcessor
    implements Processor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CoreEvent process(CoreEvent event) throws MuleException {
            List list = capturedEvents;
            synchronized (list) {
                capturedEvents.add(event);
            }
            return event;
        }
    }
}

