/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.source;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.tck.probe.PollingProber;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.petstore.extension.PetAdoptionSource;

public class PollingSourceTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final List<CoreEvent> ADOPTION_EVENTS = new LinkedList<CoreEvent>();

    protected void doTearDown() throws Exception {
        ADOPTION_EVENTS.clear();
    }

    protected String getConfigFile() {
        return "polling-source-config.xml";
    }

    @Test
    public void vanillaPoll() throws Exception {
        this.startFlow("vanilla");
        this.assertAllPetsAdopted();
        Assert.assertThat((Object)PetAdoptionSource.COMPLETED_POLLS, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(1))));
        Assert.assertThat((Object)PetAdoptionSource.ADOPTED_PET_COUNT, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(ADOPTION_EVENTS.size()))));
    }

    @Test
    public void idempotentPoll() throws Exception {
        this.startFlow("idempotent");
        PollingProber.check((long)5000L, (long)100L, () -> {
            List<CoreEvent> list = ADOPTION_EVENTS;
            synchronized (list) {
                return PetAdoptionSource.REJECTED_ADOPTIONS >= PetAdoptionSource.ALL_PETS.size() && PetAdoptionSource.ALL_PETS.containsAll(ADOPTION_EVENTS.stream().map(e -> e.getMessage().getPayload().getValue().toString()).collect(Collectors.toList()));
            }
        });
        this.assertIdempotentAdoptions();
    }

    @Test
    public void idempotentLocksAreReleased() throws Exception {
        this.startFlow("idempotentLocksAreReleased");
        this.assertAllPetsAdopted();
        this.doTearDown();
        this.assertAllPetsAdopted();
    }

    @Test
    public void watermarkPoll() throws Exception {
        this.startFlow("watermark");
        this.assertAllPetsAdopted();
        this.assertIdempotentAdoptions();
    }

    @Test
    public void failingPoll() throws Exception {
        this.startFlow("failingPoll");
        PollingProber.check((long)5000L, (long)100L, () -> PetAdoptionSource.FAILED_ADOPTION_COUNT >= PetAdoptionSource.ALL_PETS.size());
    }

    private void assertIdempotentAdoptions() {
        PollingProber.checkNot((long)5000L, (long)100L, () -> {
            List<CoreEvent> list = ADOPTION_EVENTS;
            synchronized (list) {
                return ADOPTION_EVENTS.size() > PetAdoptionSource.ALL_PETS.size();
            }
        });
    }

    private void assertAllPetsAdopted() {
        PollingProber.check((long)5000L, (long)100L, () -> {
            List<CoreEvent> list = ADOPTION_EVENTS;
            synchronized (list) {
                return ADOPTION_EVENTS.size() >= PetAdoptionSource.ALL_PETS.size() && PetAdoptionSource.ALL_PETS.containsAll(ADOPTION_EVENTS.stream().map(e -> e.getMessage().getPayload().getValue().toString()).collect(Collectors.toList()));
            }
        });
    }

    private void startFlow(String flowName) throws Exception {
        ((Startable)this.getFlowConstruct(flowName)).start();
    }

    public static class AdoptionProcessor
    implements Processor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CoreEvent process(CoreEvent event) throws MuleException {
            List list = ADOPTION_EVENTS;
            synchronized (list) {
                ADOPTION_EVENTS.add(event);
            }
            return event;
        }
    }
}

