/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.streaming;

import java.io.IOException;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class ReconnectionWithStreamingTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final long ORIGINAL_POSITION = 10L;

    protected String getConfigFile() {
        return "reconnection-with-streaming-config.xml";
    }

    @Test
    public void cursorComingFromProviderIsResetOnReconnection() throws Exception {
        CursorStream cursorStream = this.createMockCursor();
        CursorStreamProvider provider = (CursorStreamProvider)Mockito.mock(CursorStreamProvider.class);
        Mockito.when((Object)provider.openCursor()).thenReturn((Object)cursorStream);
        this.assertReconnection(cursorStream, provider);
    }

    @Test
    public void standaloneCursorIsResetOnReconnection() throws Exception {
        CursorStream cursorStream = this.createMockCursor();
        this.assertReconnection(cursorStream, cursorStream);
    }

    private void assertReconnection(CursorStream cursor, Object container) throws Exception {
        CoreEvent response = ((FlowRunner)this.flowRunner("streamingReconnect").withVariable("signature", container)).run();
        ((CursorStream)Mockito.verify((Object)cursor)).seek(10L);
        ((CursorStream)Mockito.verify((Object)cursor, (VerificationMode)Mockito.times((int)3))).read((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
        Object payload = response.getMessage().getPayload().getValue();
        Assert.assertThat((Object)payload, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(List.class)));
        Assert.assertThat((Object)((List)payload), (Matcher)org.hamcrest.Matchers.hasSize((int)3));
    }

    private CursorStream createMockCursor() throws IOException {
        CursorStream cursorStream = (CursorStream)Mockito.mock(CursorStream.class);
        Mockito.when((Object)cursorStream.getPosition()).thenReturn((Object)10L);
        Mockito.when((Object)cursorStream.read((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt())).thenThrow(new Throwable[]{new RuntimeException((Throwable)new ConnectionException("kaboom"))}).thenAnswer(i -> {
            byte[] buffer = (byte[])i.getArguments()[0];
            buffer[0] = 104;
            buffer[1] = 110;
            return 2;
        }).thenReturn((Object)-1);
        return cursorStream;
    }
}

