/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.values;

import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Test;
import org.mule.runtime.api.value.Value;
import org.mule.test.module.extension.values.AbstractValuesTestCase;

public class ConnectionProviderValuesTestCase
extends AbstractValuesTestCase {
    protected String getConfigFile() {
        return "values/connection-provider-values.xml";
    }

    @Test
    public void connectionWithValues() throws Exception {
        Set<Value> channels = this.getValuesFromConnection("with-value-parameter-connection", "channel");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)3));
        MatcherAssert.assertThat(channels, this.hasValues("channel1", "channel2", "channel3"));
    }

    @Test
    public void connectionWithValuesAndRequiredParameters() throws Exception {
        Set<Value> channels = this.getValuesFromConnection("with-value-with-required-param-connection", "channel");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)2));
        MatcherAssert.assertThat(channels, this.hasValues("required2:value2", "required1:value1"));
    }

    @Test
    public void connectionWithValuesWithRequiredParamsFromParamGroup() throws Exception {
        Set<Value> channels = this.getValuesFromConnection("values-with-required-params-from-param-group-connection", "valueParam");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat(channels, this.hasValues("anyParameter:someValue"));
    }

    @Test
    public void connectionWithValuesWithRequiredParamsFromShowInDslGroup() throws Exception {
        Set<Value> channels = this.getValuesFromConnection("values-with-required-params-from-show-in-dsl-group-connection", "valueParam");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat(channels, this.hasValues("anyParameter:someValue"));
    }
}

