/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.notification;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.notification.ExtensionNotification;
import org.mule.runtime.api.notification.ExtensionNotificationListener;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.test.heisenberg.extension.model.PersonalInfo;
import org.mule.test.heisenberg.extension.model.SimpleKnockeableDoor;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class ExtensionNotificationsTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final String HEISENBERG = "Heisenberg".toUpperCase();
    private TestExtensionNotificationListener listener;
    @Inject
    private NotificationListenerRegistry notificationListenerRegistry;

    protected String getConfigFile() {
        return "notifications-config.xml";
    }

    @Test
    public void operationFiresNotificationsWithCustomData() throws Exception {
        CountDownLatch latch = new CountDownLatch(2);
        this.setUpListener(notification -> latch.countDown());
        String correlationId = this.flowRunner("operationNotification").run().getCorrelationId();
        latch.await(2000L, TimeUnit.MILLISECONDS);
        Assert.assertThat(this.listener.getNotifications(), (Matcher)Matchers.hasSize((int)2));
        ExtensionNotification notification1 = this.listener.getNotifications().get(0);
        Assert.assertThat((Object)notification1.getAction().getNamespace(), (Matcher)Matchers.is((Object)HEISENBERG));
        Assert.assertThat((Object)notification1.getAction().getIdentifier(), (Matcher)Matchers.is((Object)"KNOCKING_DOOR"));
        Assert.assertThat((Object)notification1.getData().getValue(), (Matcher)Matchers.instanceOf(SimpleKnockeableDoor.class));
        Assert.assertThat((Object)((SimpleKnockeableDoor)notification1.getData().getValue()).getSimpleName(), (Matcher)Matchers.is((Object)"Top Level Skyler @ 308 Negra Arroyo Lane"));
        Assert.assertThat((Object)notification1.getEvent().getCorrelationId(), (Matcher)Matchers.is((Object)correlationId));
        ExtensionNotification notification2 = this.listener.getNotifications().get(1);
        Assert.assertThat((Object)notification2.getAction().getNamespace(), (Matcher)Matchers.is((Object)HEISENBERG));
        Assert.assertThat((Object)notification2.getAction().getIdentifier(), (Matcher)Matchers.is((Object)"KNOCKED_DOOR"));
        Assert.assertThat((Object)notification2.getData().getValue(), (Matcher)Matchers.instanceOf(SimpleKnockeableDoor.class));
        Assert.assertThat((Object)((SimpleKnockeableDoor)notification2.getData().getValue()).getSimpleName(), (Matcher)Matchers.is((Object)"Top Level Skyler @ 308 Negra Arroyo Lane"));
        Assert.assertThat((Object)notification2.getEvent().getCorrelationId(), (Matcher)Matchers.is((Object)correlationId));
    }

    @Test
    public void sourceFiresNotificationsOnSuccess() throws Exception {
        CountDownLatch latch = new CountDownLatch(4);
        this.setUpListener(notification -> latch.countDown());
        Flow flow = (Flow)this.getFlowConstruct("sourceNotifications");
        flow.start();
        latch.await(4000L, TimeUnit.MILLISECONDS);
        Assert.assertThat(this.listener.getNotifications(), (Matcher)Matchers.hasSize((int)4));
        ExtensionNotification notification1 = this.listener.getNotifications().get(0);
        this.verifyNewBatch(notification1, 1);
        String correlationId = notification1.getEvent().getCorrelationId();
        ExtensionNotification notification2 = this.listener.getNotifications().get(1);
        this.verifyNextBatch(notification2, 100000L);
        Assert.assertThat((Object)notification2.getEvent().getCorrelationId(), (Matcher)Matchers.is((Object)correlationId));
        ExtensionNotification notification3 = this.listener.getNotifications().get(2);
        this.verifyNotificationAndValue(notification3, "BATCH_DELIVERED", 100L);
        Assert.assertThat((Object)notification3.getEvent().getCorrelationId(), (Matcher)Matchers.is((Object)correlationId));
        ExtensionNotification notification4 = this.listener.getNotifications().get(3);
        this.verifyBatchTerminated(notification4, 1);
        Assert.assertThat((Object)notification4.getEvent().getCorrelationId(), (Matcher)Matchers.is((Object)correlationId));
    }

    @Test
    public void sourceFiresNotificationsOnError() throws Exception {
        CountDownLatch latch = new CountDownLatch(4);
        this.setUpListener(notification -> latch.countDown());
        Flow flow = (Flow)this.getFlowConstruct("sourceNotificationsError");
        flow.start();
        latch.await(4000L, TimeUnit.MILLISECONDS);
        Assert.assertThat(this.listener.getNotifications(), (Matcher)Matchers.hasSize((int)4));
        ExtensionNotification notification1 = this.listener.getNotifications().get(0);
        this.verifyNewBatch(notification1, 1);
        String correlationId = notification1.getEvent().getCorrelationId();
        ExtensionNotification notification2 = this.listener.getNotifications().get(1);
        this.verifyNextBatch(notification2, 100000L);
        Assert.assertThat((Object)notification2.getEvent().getCorrelationId(), (Matcher)Matchers.is((Object)correlationId));
        ExtensionNotification notification3 = this.listener.getNotifications().get(2);
        Assert.assertThat((Object)notification3.getAction().getNamespace(), (Matcher)Matchers.is((Object)HEISENBERG));
        Assert.assertThat((Object)notification3.getAction().getIdentifier(), (Matcher)Matchers.is((Object)"BATCH_DELIVERY_FAILED"));
        Assert.assertThat((Object)notification3.getData().getValue(), (Matcher)Matchers.instanceOf(PersonalInfo.class));
        Assert.assertThat((Object)((PersonalInfo)notification3.getData().getValue()).getAge(), (Matcher)Matchers.is((Object)27));
        Assert.assertThat((Object)notification3.getEvent().getCorrelationId(), (Matcher)Matchers.is((Object)correlationId));
        ExtensionNotification notification4 = this.listener.getNotifications().get(3);
        this.verifyBatchTerminated(notification4, 1);
        Assert.assertThat((Object)notification4.getEvent().getCorrelationId(), (Matcher)Matchers.is((Object)correlationId));
    }

    @Test
    public void sourceFiresNotificationsOnBackPressure() throws Exception {
        Latch latch = new Latch();
        String batchFailed = "BATCH_FAILED";
        this.setUpListener(notification -> {
            if (batchFailed.equals(notification.getAction().getIdentifier())) {
                latch.release();
            }
        });
        Flow flow = (Flow)this.getFlowConstruct("sourceNotificationsBackPressure");
        flow.start();
        latch.await(10000L, TimeUnit.MILLISECONDS);
        flow.stop();
        Assert.assertThat(this.listener.getNotifications(), (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(3))));
        ExtensionNotification backPressureNotification = this.listener.getNotifications().stream().filter(n -> batchFailed.equals(n.getAction().getIdentifier())).findFirst().get();
        List notifications = this.listener.getNotifications().stream().filter(n -> backPressureNotification.getEvent().getCorrelationId().equals(n.getEvent().getCorrelationId())).collect(Collectors.toList());
        Assert.assertThat(notifications, (Matcher)Matchers.hasSize((int)4));
        int batchNumber = (Integer)backPressureNotification.getData().getValue();
        ExtensionNotification notification1 = (ExtensionNotification)notifications.get(0);
        this.verifyNewBatch(notification1, batchNumber);
        ExtensionNotification notification2 = (ExtensionNotification)notifications.get(1);
        this.verifyNextBatch(notification2, 10L);
        ExtensionNotification notification3 = (ExtensionNotification)notifications.get(2);
        this.verifyNotificationAndValue(notification3, batchFailed, batchNumber);
        ExtensionNotification notification4 = (ExtensionNotification)notifications.get(3);
        this.verifyBatchTerminated(notification4, batchNumber);
    }

    private void verifyNewBatch(ExtensionNotification notification, Integer expected) {
        this.verifyNotificationAndValue(notification, "NEW_BATCH", expected);
    }

    private void verifyNextBatch(ExtensionNotification notification, Long expected) {
        this.verifyNotificationAndValue(notification, "NEXT_BATCH", expected);
    }

    private void verifyBatchTerminated(ExtensionNotification notification, int expected) {
        this.verifyNotificationAndValue(notification, "BATCH_TERMINATED", expected);
    }

    private <T> void verifyNotificationAndValue(ExtensionNotification notification, String id, T expected) {
        Assert.assertThat((Object)notification.getAction().getNamespace(), (Matcher)Matchers.is((Object)HEISENBERG));
        Assert.assertThat((Object)notification.getAction().getIdentifier(), (Matcher)Matchers.is((Object)id));
        Assert.assertThat((Object)notification.getData().getValue(), (Matcher)Matchers.instanceOf(expected.getClass()));
        Assert.assertThat((Object)notification.getData().getValue(), (Matcher)Matchers.is(expected));
    }

    private void setUpListener(Consumer<ExtensionNotification> onNotification) {
        this.listener = new TestExtensionNotificationListener(onNotification);
        this.notificationListenerRegistry.registerListener((NotificationListener)this.listener);
    }

    private class TestExtensionNotificationListener
    implements ExtensionNotificationListener {
        private Consumer<ExtensionNotification> onNotification;
        private List<ExtensionNotification> notifications = new LinkedList<ExtensionNotification>();

        public TestExtensionNotificationListener(Consumer<ExtensionNotification> onNotification) {
            this.onNotification = onNotification;
        }

        public void onNotification(ExtensionNotification notification) {
            this.notifications.add(notification);
            this.onNotification.accept(notification);
        }

        public List<ExtensionNotification> getNotifications() {
            return this.notifications;
        }
    }
}

